/*
 * Decompiled with CFR 0.152.
 */
package com.testflightapp.lib;

import android.app.Application;
import android.content.Context;
import com.testflightapp.acra.ACRA;
import com.testflightapp.acra.ReportField;
import com.testflightapp.lib.BundleInfo;
import com.testflightapp.lib.Constants;
import com.testflightapp.lib.DeviceInfo;
import com.testflightapp.lib.core.AndroidLogger;
import com.testflightapp.lib.core.Logger;
import com.testflightapp.lib.core.crashes.TFCrashSender;
import com.testflightapp.lib.core.networking.NetworkEnvironment;
import com.testflightapp.lib.core.networking.TestFlightHost;
import com.testflightapp.lib.core.newapi.AppStateWatcher;
import com.testflightapp.lib.core.newapi.ConnectionStateWatcher;
import com.testflightapp.lib.core.newapi.Job;
import com.testflightapp.lib.core.newapi.JobScheduler;
import com.testflightapp.lib.core.newapi.RegisterApplicationJob;
import com.testflightapp.lib.core.newapi.SessionJob;
import com.testflightapp.lib.core.newapi.TermintateJob;
import com.testflightapp.lib.events.CheckpointEvent;
import com.testflightapp.lib.events.CrashEvent;
import com.testflightapp.lib.events.SessionEndEvent;
import com.testflightapp.lib.events.SessionEvent;
import com.testflightapp.lib.events.SessionStartEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;

public class TestFlight {
    public static final NetworkEnvironment ENV = NetworkEnvironment.PRODUCTION;
    public static final boolean DEBUG_MODE = false;
    private static final String APP_TOKEN_MASK = "XXXXXXXX-XXXX-XXXX-XXXX-XXXXXXXXXXXX";
    private static final List<SessionEndEvent.EventLogLine> LOGS = new ArrayList<SessionEndEvent.EventLogLine>();
    private static Application sApp;
    private static String sAppToken;
    private static volatile boolean sIsActive;
    private static String sSessionID;
    private static Map<String, Object> sBundleInfo;
    private static Map<String, Object> sDeviceInfo;
    static JobScheduler sJobDispatcher;
    static AppStateWatcher sAppStateWatcher;
    static SessionJob sSessionJob;
    static RegisterApplicationJob sRegisterJob;
    private static boolean sSendLogs;
    static boolean sSendCheckpoints;
    private static boolean sSendCrashes;
    private static int sSessionTimeout;
    private static long sBackgroundingTime;
    static volatile boolean sTokenResponseRecieved;
    private static boolean sInitCrashReporting;
    private static AppStateWatcher.IStateChangeListener sAppStateChangedCallback;

    public static void disableCrashReporting() {
        sInitCrashReporting = false;
        sSendCrashes = false;
    }

    public static boolean isActive() {
        return sIsActive;
    }

    public static Application getApp() {
        return sApp;
    }

    public static String getAppToken() {
        return sAppToken;
    }

    public static Map<String, Object> getBundleInfo() {
        return sBundleInfo;
    }

    public static Map<String, Object> getDeviceInfo() {
        return sDeviceInfo;
    }

    private static void generateSessionID() {
        sSessionID = UUID.randomUUID().toString();
    }

    public static String getSessionID() {
        return sSessionID;
    }

    public static boolean sendsLogs() {
        return sSendLogs;
    }

    public static boolean sendsCrashes() {
        return sSendCrashes;
    }

    public static boolean sendsCheckpoints() {
        return sSendCheckpoints;
    }

    public static void setSessionTimeout(int n) {
        sSessionTimeout = n;
    }

    public static synchronized void takeOff(Application application, String string) {
        if (!sIsActive) {
            String string2 = TestFlightHost.getHost(ENV, string);
            TestFlight.baseInit(application, string, string2, new TFEndpointCallbacks());
            TestFlight.start();
            Logger.d("TestFlight takeOff complete. Version: " + Constants.VERSION);
        } else {
            Logger.d("TestFlight has already taken off.");
        }
    }

    static void baseInit(Application application, String string, String string2, TFEndpointCallbacks tFEndpointCallbacks) {
        TestFlight.validateAppToken(string);
        if (sInitCrashReporting) {
            Logger.d("Initializing Crash Reporting.");
            ACRA.init(application);
            ACRA.getErrorReporter().setReportSender(new TFCrashSender());
            ACRA.getConfig().setCustomReportContent(new ReportField[]{ReportField.STACK_TRACE, ReportField.THREAD_DETAILS});
        } else {
            Logger.d("Crash Reporting has not been initialized.");
        }
        sTokenResponseRecieved = false;
        sAppToken = string;
        sApp = application;
        sBundleInfo = new TreeMap<String, Object>();
        sDeviceInfo = new TreeMap<String, Object>();
        BundleInfo.pack((Context)sApp, sAppToken, sBundleInfo);
        DeviceInfo.pack((Context)sApp, sDeviceInfo);
        sJobDispatcher = new JobScheduler();
        sAppStateWatcher = new AppStateWatcher((Context)application, sAppStateChangedCallback);
        sSessionJob = new SessionJob((Context)application, tFEndpointCallbacks, string2, sBundleInfo);
        sRegisterJob = new RegisterApplicationJob(tFEndpointCallbacks, string2);
        ConnectionStateWatcher.initRquestManager((Context)application);
        ConnectionStateWatcher.addConnectionListener(sSessionJob);
        ConnectionStateWatcher.addConnectionListener(sRegisterJob);
    }

    static void start() {
        SessionEvent.setSessionStartEventTimeToNow();
        sJobDispatcher.start();
        sJobDispatcher.addJob(sAppStateWatcher);
        sJobDispatcher.addJob(sRegisterJob);
        if (ConnectionStateWatcher.isConnected()) {
            sRegisterJob.onConnected();
        }
        sIsActive = true;
    }

    static void stop() {
        if (sJobDispatcher != null) {
            sJobDispatcher.stop();
        }
        sJobDispatcher = null;
        sIsActive = false;
        Logger.d("TestFlight has successfully landed.");
    }

    static void baseDeinit() {
        sApp = null;
        sAppToken = null;
        sSessionID = null;
        sAppStateChangedCallback = null;
        sSessionJob = null;
        sAppStateWatcher = null;
        sDeviceInfo = null;
        sBundleInfo = null;
        sRegisterJob = null;
        sSendLogs = false;
        sSendCrashes = false;
        sSendCheckpoints = false;
    }

    public static synchronized void land() {
        if (sIsActive) {
            TestFlight.baseDeinit();
            TestFlight.stop();
        }
    }

    public static void endSession() {
        TestFlight.endSession(System.currentTimeMillis());
    }

    public static void startSession() {
        if (sIsActive) {
            TestFlight.generateSessionID();
            SessionEvent.setSessionStartEventTimeToNow();
            sSessionJob.addEvent(new SessionStartEvent(sApp.getApplicationContext()));
            TestFlight.forceEventFlush();
        } else {
            Logger.w("TestFlight hasn't taken off yet. Call takeOff before");
        }
    }

    public static void endSession(long l) {
        if (sIsActive) {
            sSessionJob.addEvent(new SessionEndEvent(l, LOGS));
            TestFlight.startSession();
        } else {
            Logger.w("TestFlight hasn't taken off yet. Call takeOff before");
        }
    }

    public static void sendCrash(long l, String string, String string2) {
        if (sSendCrashes) {
            if (sIsActive) {
                Logger.d("Adding crash event.");
                sSessionJob.addEvent(new SessionEndEvent(l, LOGS));
                sSessionJob.addEvent(new CrashEvent(l, string, string2));
                if (sTokenResponseRecieved) {
                    TestFlight.forceEventFlush();
                    TestFlight.terminateJobDispatcher();
                    sJobDispatcher.waitForExit();
                }
            } else {
                Logger.w("TestFlight hasn't taken off yet. Call takeOff before");
            }
        } else {
            Logger.w("Crash reporting is disabled or the application has not been registered yet.");
        }
    }

    public static void passCheckpoint(String string) {
        if (sSendCheckpoints) {
            if (sIsActive) {
                sSessionJob.addEvent(new CheckpointEvent(string));
            } else {
                Logger.w("TestFlight hasn't taken off yet. Call takeOff before");
            }
        }
    }

    static void forceEventFlush() {
        if (sIsActive && sSendCheckpoints && sTokenResponseRecieved) {
            sSessionJob.flushEvents();
            sJobDispatcher.addUrgentJob(sSessionJob);
        } else {
            Logger.w("TestFlight hasn't taken off yet. Call takeOff before");
        }
    }

    private static void terminateJobDispatcher() {
        sJobDispatcher.addJob(new TermintateJob(sJobDispatcher));
    }

    public static void log(String string) {
        LOGS.add(new SessionEndEvent.EventLogLine(string));
    }

    private static void validateAppToken(String string) {
        if (string == null) {
            throw new NullPointerException("Null App Token");
        }
        if (string.length() != APP_TOKEN_MASK.length()) {
            throw new RuntimeException("Invalid App Token \"" + string + "\".  App tokens must be 36 characters long including dashes.");
        }
        int[] nArray = new int[]{8, 13, 18, 23, -1};
        char[] cArray = string.toLowerCase(Locale.US).toCharArray();
        int n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (i == nArray[n]) {
                if (c != '-') {
                    throw new RuntimeException("Invalid App Token \"" + string + "\". App tokens must be of the format " + APP_TOKEN_MASK);
                }
                ++n;
                continue;
            }
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f') continue;
            throw new RuntimeException("Invalid App Token \"" + string + "\". Char '" + c + "' at index " + i + " is not a valid token.");
        }
    }

    static {
        sSendLogs = true;
        sSendCheckpoints = true;
        sSendCrashes = true;
        sSessionTimeout = 30000;
        sInitCrashReporting = true;
        sAppStateChangedCallback = new AppStateWatcher.IStateChangeListener(){

            @Override
            public void appStateChanged(boolean bl) {
                long l;
                Logger.i("App " + (bl ? "moved to background" : "came to foreground"));
                if (bl) {
                    sBackgroundingTime = System.currentTimeMillis();
                } else if (sBackgroundingTime != 0L && (l = System.currentTimeMillis() - sBackgroundingTime) > (long)sSessionTimeout) {
                    TestFlight.endSession(sBackgroundingTime);
                }
            }
        };
        AndroidLogger.setAsLogger("TestFlight SDK");
    }

    static class TFEndpointCallbacks
    implements SessionJob.INetworkJobListener,
    RegisterApplicationJob.IRegisterAppJobListener {
        TFEndpointCallbacks() {
        }

        @Override
        public void onSessionsRequestFinished(SessionJob sessionJob, SessionEvent[] sessionEventArray, Map<String, Object> map) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onTokensRequestFinished(Job job, Map<String, Object> map) {
            Class<TestFlight> clazz = TestFlight.class;
            synchronized (TestFlight.class) {
                if (sIsActive) {
                    sTokenResponseRecieved = true;
                    if (map.containsKey("valid") && ((Boolean)map.get("valid")).booleanValue()) {
                        sSendLogs = map.containsKey("send_logs") && (Boolean)map.get("send_logs") != false;
                        sSendCheckpoints = map.containsKey("send_checkpoints") && (Boolean)map.get("send_checkpoints") != false;
                        sSendCrashes = sInitCrashReporting && map.containsKey("send_crashes") && (Boolean)map.get("send_crashes") != false;
                        if (sSendCheckpoints) {
                            sJobDispatcher.addJob(sSessionJob);
                            TestFlight.startSession();
                        }
                    } else {
                        Logger.e("Application rejected. Landing...");
                        sSessionJob.clearAllEvents();
                        TestFlight.land();
                    }
                    sJobDispatcher.removeJob(sRegisterJob);
                    sRegisterJob = null;
                } else {
                    Logger.w("TestFlight hasn't taken off yet. Call takeOff before");
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }
    }
}

