/*
 * Decompiled with CFR 0.152.
 */
package com.bzutils;

import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;

public class BZScreenHelper {
    public static int width;
    public static int height;

    public static int dpToPx(Context ctx, int dp) {
        return (int)((float)dp * ctx.getResources().getDisplayMetrics().density + 0.5f);
    }

    public static void resizeImageView(Context ctx, ImageView imageView, RelativeLayout layoutselected) {
        BZScreenHelper.getScreenMeasures(ctx);
        imageView.setMaxWidth(width / 4);
        imageView.setMaxHeight(width / 4);
        ViewGroup.LayoutParams params = imageView.getLayoutParams();
        params.width = width / 4;
        params.height = width / 4;
        imageView.setLayoutParams(params);
        if (layoutselected != null) {
            layoutselected.setLayoutParams(params);
        }
    }

    public static void getScreenMeasures(Context ctx) {
        DisplayMetrics metrics = ctx.getResources().getDisplayMetrics();
        width = metrics.widthPixels;
        height = metrics.heightPixels;
    }

    public static int getScreenWidth(Context ctx) {
        DisplayMetrics metrics = ctx.getResources().getDisplayMetrics();
        return metrics.widthPixels;
    }

    public static int getScreenHeight(Context ctx) {
        DisplayMetrics metrics = ctx.getResources().getDisplayMetrics();
        return metrics.heightPixels;
    }

    public static float dpFromPx(float px, Context context) {
        return px / context.getResources().getDisplayMetrics().density;
    }

    public static View getViewFromActivity(Activity currentActivity) {
        return currentActivity.getWindow().getDecorView().findViewById(0x1020002);
    }

    public static void checkHeightDifference(View v, int mLastHeightDifferece) {
        Rect r = new Rect();
        v.getWindowVisibleDisplayFrame(r);
        int screenHeight = v.getRootView().getHeight();
        int heightDifference = screenHeight - (r.bottom - r.top);
        if (heightDifference > screenHeight / 3 && heightDifference != mLastHeightDifferece) {
            FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)v.getLayoutParams();
            lp.height = screenHeight - heightDifference;
            v.requestLayout();
            mLastHeightDifferece = heightDifference;
        } else if (heightDifference != mLastHeightDifferece) {
            FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)v.getLayoutParams();
            lp.height = screenHeight;
            v.requestLayout();
            mLastHeightDifferece = heightDifference;
        }
    }
}

