/*
 * Decompiled with CFR 0.152.
 */
package com.testflightapp.lib.core.newapi;

import android.os.Looper;
import android.util.Log;
import com.testflightapp.lib.core.newapi.IJobScheduler;
import com.testflightapp.lib.core.newapi.Job;
import com.testflightapp.lib.core.newapi.JobHandler;
import com.testflightapp.lib.core.newapi.SchedulerAwareJob;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class JobScheduler
implements IJobScheduler {
    private static final String TAG = JobScheduler.class.getSimpleName();
    final Lock mLock = new ReentrantLock();
    private Thread mDispatchThread;
    private boolean mStopped;
    volatile JobHandler mHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        final Condition condition = this.mLock.newCondition();
        this.mLock.lock();
        try {
            if (this.mDispatchThread == null) {
                this.mDispatchThread = new Thread("Job dispatcher thread"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Looper.prepare();
                        JobScheduler.this.mHandler = new JobHandler(JobScheduler.this.mLock);
                        JobScheduler.this.mLock.lock();
                        try {
                            condition.signalAll();
                        }
                        finally {
                            JobScheduler.this.mLock.unlock();
                            Looper.loop();
                        }
                    }
                };
                this.mDispatchThread.start();
                while (this.mHandler == null) {
                    condition.awaitUninterruptibly();
                }
            }
        }
        finally {
            this.mStopped = false;
            this.mLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addJob(Job job) {
        JobHandler jobHandler = this.mHandler;
        if (jobHandler != null) {
            this.mLock.lock();
            try {
                this.removeJob(job);
                jobHandler.sendMessage(JobHandler.getMessage(jobHandler, job));
            }
            finally {
                this.mLock.unlock();
            }
        }
    }

    public void addJob(SchedulerAwareJob schedulerAwareJob) {
        schedulerAwareJob.setScheduler(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addUrgentJob(Job job) {
        JobHandler jobHandler = this.mHandler;
        if (jobHandler != null) {
            this.mLock.lock();
            try {
                this.removeJob(job);
                jobHandler.sendMessageAtFrontOfQueue(JobHandler.getMessage(jobHandler, job));
            }
            finally {
                this.mLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.mLock.lock();
        try {
            if (!this.mStopped) {
                if (this.mHandler != null) {
                    this.mHandler.post(this.mHandler);
                } else {
                    Log.wtf((String)TAG, (String)"mHandler is null and this is unexpected!");
                }
            }
        }
        finally {
            this.mStopped = true;
            this.mDispatchThread = null;
            this.mHandler = null;
            this.mLock.unlock();
        }
    }

    public void waitForExit() {
        Thread thread = this.mDispatchThread;
        if (thread != null) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeJob(Job job) {
        JobHandler jobHandler = this.mHandler;
        if (jobHandler != null) {
            this.mLock.lock();
            try {
                jobHandler.removeMessages(job.getJobId());
            }
            finally {
                this.mLock.unlock();
            }
        }
    }
}

