/*
 * Decompiled with CFR 0.152.
 */
package com.bzutils;

import android.content.Context;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Handler;
import android.os.Message;
import com.bzutils.LogBZ;
import com.bzutils.exception.BZLocationException;
import java.util.List;

public class Localizator {
    protected static final int TIMEOUT_MESSAGE = 256;
    public static final String KILOMETRES = "K";
    public static final String MILES = "M";
    LocationManager locationManager;
    private Handler locationTimeoutHandler;
    private int locationTimeCount = 0;
    private int locationTimeout = 5;
    public boolean localizado = false;
    Context c;
    private Runnable locationTimer = new Runnable(){

        @Override
        public void run() {
            Localizator.this.locationTimeCount++;
            if (Localizator.this.locationTimeCount < Localizator.this.locationTimeout) {
                Localizator.this.locationTimeoutHandler.postDelayed((Runnable)this, 1000L);
            } else {
                Localizator.this.locationTimeoutHandler.removeCallbacks((Runnable)this);
                Message msg = new Message();
                msg.what = 256;
                Localizator.this.locationTimeoutHandler.sendMessage(msg);
            }
        }
    };

    public Localizator(Context c) {
        this.c = c;
    }

    public void localizate(final LocationListener listener) throws BZLocationException {
        LogBZ.getInstance().i("Getting user's location");
        this.locationManager = (LocationManager)this.c.getSystemService("location");
        List enabledProviders = this.locationManager.getProviders(true);
        if (enabledProviders.size() == 0 || enabledProviders.size() == 1 && ((String)enabledProviders.get(0)).equals("passive")) {
            listener.onProviderDisabled("ALL");
            LogBZ.getInstance().i("Location providers are disabled");
        }
        if (this.locationManager.isProviderEnabled("network")) {
            this.locationManager.requestLocationUpdates("network", 0L, 0.0f, listener);
        }
        if (this.locationManager.isProviderEnabled("gps")) {
            this.locationManager.requestLocationUpdates("gps", 0L, 0.0f, listener);
        }
        this.locationTimeoutHandler = new Handler(){

            public void handleMessage(Message msg) {
                switch (msg.what) {
                    case 256: {
                        Localizator.this.locationManager.removeUpdates(listener);
                        listener.onProviderDisabled("TIMEOUT");
                        LogBZ.getInstance();
                        LogBZ.e("Timeout getting location");
                    }
                }
                super.handleMessage(msg);
            }
        };
        this.locationTimeoutHandler.postDelayed(this.locationTimer, 1000L);
    }

    public static double calculateDistance(Location from, Location to, String unit) {
        if (from == null) {
            return -1.0;
        }
        double lat1 = from.getLatitude();
        double lon1 = from.getLongitude();
        double lat2 = to.getLatitude();
        double lon2 = to.getLongitude();
        double theta = lon1 - lon2;
        double dist = Math.sin(Localizator.deg2rad(lat1)) * Math.sin(Localizator.deg2rad(lat2)) + Math.cos(Localizator.deg2rad(lat1)) * Math.cos(Localizator.deg2rad(lat2)) * Math.cos(Localizator.deg2rad(theta));
        dist = Math.acos(dist);
        dist = Localizator.rad2deg(dist);
        dist = dist * 60.0 * 1.1515;
        if (unit == KILOMETRES) {
            dist *= 1.609344;
        } else if (unit == MILES) {
            dist *= 0.8684;
        }
        return dist;
    }

    private static double deg2rad(double deg) {
        return deg * Math.PI / 180.0;
    }

    private static double rad2deg(double rad) {
        return rad * 180.0 / Math.PI;
    }
}

