/*
 * Decompiled with CFR 0.152.
 */
package net.mm2d.preference;

import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.os.Bundle;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.util.Xml;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.XmlRes;
import java.io.IOException;
import java.util.List;
import net.mm2d.preference.Header;
import net.mm2d.preference.R;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

class HeaderLoader {
    HeaderLoader() {
    }

    static void loadFromResource(@NonNull Context context, @XmlRes int resId, @NonNull List<Header> target) {
        try (XmlResourceParser parser = null;){
            parser = context.getResources().getXml(resId);
            HeaderLoader.loadFromResource(context, parser, target);
        }
    }

    private static void loadFromResource(@NonNull Context context, @NonNull XmlResourceParser parser, @NonNull List<Header> target) throws IOException, XmlPullParserException {
        int type;
        int type2;
        AttributeSet attrs = Xml.asAttributeSet((XmlPullParser)parser);
        while ((type2 = parser.next()) != 1 && type2 != 2) {
        }
        if (!"preference-headers".equals(parser.getName())) {
            throw new RuntimeException("XML document must start with <preference-headers> tag; found" + parser.getName() + " at " + parser.getPositionDescription());
        }
        int startDepth = parser.getDepth();
        while (!HeaderLoader.reachToEnd(type = parser.next(), parser.getDepth(), startDepth)) {
            if (type == 3 || type == 4) continue;
            if ("header".equals(parser.getName())) {
                target.add(HeaderLoader.parseHeaderSection(context, parser, attrs));
                continue;
            }
            HeaderLoader.skipCurrentTag((XmlPullParser)parser);
        }
    }

    private static Header parseHeaderSection(@NonNull Context context, @NonNull XmlResourceParser parser, @NonNull AttributeSet attrs) throws IOException, XmlPullParserException {
        Header header = new Header();
        TypedArray sa = context.obtainStyledAttributes(attrs, R.styleable.PreferenceHeader);
        header.id = sa.getResourceId(R.styleable.PreferenceHeader_id, -1);
        HeaderLoader.setTitle(header, sa.peekValue(R.styleable.PreferenceHeader_title));
        HeaderLoader.setSummary(header, sa.peekValue(R.styleable.PreferenceHeader_summary));
        HeaderLoader.setBreadCrumbTitle(header, sa.peekValue(R.styleable.PreferenceHeader_breadCrumbTitle));
        header.iconRes = sa.getResourceId(R.styleable.PreferenceHeader_icon, 0);
        header.fragment = sa.getString(R.styleable.PreferenceHeader_fragment);
        sa.recycle();
        HeaderLoader.parseIntentSection(context, parser, attrs, header);
        return header;
    }

    private static void setTitle(@NonNull Header header, @Nullable TypedValue tv) {
        if (tv == null || tv.type != 3) {
            return;
        }
        if (tv.resourceId != 0) {
            header.titleRes = tv.resourceId;
        } else {
            header.title = tv.string;
        }
    }

    private static void setSummary(@NonNull Header header, @Nullable TypedValue tv) {
        if (tv == null || tv.type != 3) {
            return;
        }
        if (tv.resourceId != 0) {
            header.summaryRes = tv.resourceId;
        } else {
            header.summary = tv.string;
        }
    }

    private static void setBreadCrumbTitle(@NonNull Header header, @Nullable TypedValue tv) {
        if (tv == null || tv.type != 3) {
            return;
        }
        if (tv.resourceId != 0) {
            header.breadCrumbTitleRes = tv.resourceId;
        } else {
            header.breadCrumbTitle = tv.string;
        }
    }

    private static void parseIntentSection(@NonNull Context context, @NonNull XmlResourceParser parser, @NonNull AttributeSet attrs, @NonNull Header header) throws IOException, XmlPullParserException {
        int type;
        Bundle curBundle = new Bundle();
        int startDepth = parser.getDepth();
        block8: while (!HeaderLoader.reachToEnd(type = parser.next(), parser.getDepth(), startDepth)) {
            String innerNodeName;
            if (type == 3 || type == 4) continue;
            switch (innerNodeName = parser.getName()) {
                case "extra": {
                    context.getResources().parseBundleExtra("extra", attrs, curBundle);
                    HeaderLoader.skipCurrentTag((XmlPullParser)parser);
                    continue block8;
                }
                case "intent": {
                    header.intent = Intent.parseIntent((Resources)context.getResources(), (XmlPullParser)parser, (AttributeSet)attrs);
                    continue block8;
                }
            }
            HeaderLoader.skipCurrentTag((XmlPullParser)parser);
        }
        if (curBundle.size() > 0) {
            header.fragmentArguments = curBundle;
        }
    }

    private static void skipCurrentTag(XmlPullParser parser) throws IOException, XmlPullParserException {
        int startDepth = parser.getDepth();
        while (!HeaderLoader.reachToEnd(parser.next(), parser.getDepth(), startDepth)) {
        }
    }

    private static boolean reachToEnd(int type, int currentDepth, int startDepth) {
        if (type == 1) {
            return true;
        }
        return type == 3 && currentDepth <= startDepth;
    }
}

