/*
 * Decompiled with CFR 0.152.
 */
package net.mm2d.log.android;

import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import androidx.annotation.NonNull;
import net.mm2d.log.Log;

public class MainThreadLogPrint {
    @NonNull
    public static Log.Print get() {
        return MainThreadLogPrintImpl.getInstance();
    }

    private static class MainThreadLogPrintImpl
    implements Log.Print {
        @NonNull
        private static final MainThreadLogPrintImpl INSTANCE = new MainThreadLogPrintImpl();
        @NonNull
        private final Thread mMainThread = Looper.getMainLooper().getThread();
        @NonNull
        private final Handler mHandler = new Handler(Looper.getMainLooper());

        private MainThreadLogPrintImpl() {
        }

        @NonNull
        static MainThreadLogPrintImpl getInstance() {
            return INSTANCE;
        }

        public void println(int level, @NonNull String tag, @NonNull String message) {
            if (Thread.currentThread() == this.mMainThread) {
                this.printlnInner(level, tag, message);
                return;
            }
            this.mHandler.post(() -> this.printlnInner(level, tag, message));
        }

        private void printlnInner(int level, @NonNull String tag, @NonNull String message) {
            String[] lines;
            for (String line : lines = message.split("\n")) {
                Log.println((int)level, (String)tag, (String)line);
            }
        }
    }
}

