/*
 * Decompiled with CFR 0.152.
 */
package net.mm2d.log;

import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.util.Log;
import net.mm2d.log.Log;

public class AndroidPrint {
    @NonNull
    public static synchronized Log.Print get() {
        return AndroidPrintImpl.INSTANCE;
    }

    private static class AndroidPrintImpl
    implements Log.Print {
        private static final Log.Print INSTANCE = new AndroidPrintImpl();
        private final Thread mMainThread = Looper.getMainLooper().getThread();
        private final Handler mHandler = new Handler(Looper.getMainLooper());

        private AndroidPrintImpl() {
        }

        public void println(final int level, final @NonNull String tag, final @NonNull String message) {
            if (Thread.currentThread() == this.mMainThread) {
                this.printlnInner(level, tag, message);
                return;
            }
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    AndroidPrintImpl.this.printlnInner(level, tag, message);
                }
            });
        }

        private void printlnInner(int level, @NonNull String tag, @NonNull String message) {
            String[] lines;
            for (String line : lines = message.split("\n")) {
                Log.println((int)level, (String)tag, (String)line);
            }
        }
    }
}

