/*
 * Decompiled with CFR 0.152.
 */
package net.minidev.json.mapper;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONAware;
import net.minidev.json.JSONAwareEx;
import net.minidev.json.JSONObject;
import net.minidev.json.mapper.AMapper;
import net.minidev.json.mapper.ArraysMapper;
import net.minidev.json.mapper.BeansMapper;
import net.minidev.json.mapper.CollectionMapper;
import net.minidev.json.mapper.DefaultMapper;
import net.minidev.json.mapper.DefaultMapperCollection;

public class Mapper {
    private static final ConcurrentHashMap<Type, AMapper<?>> cache = new ConcurrentHashMap(100);

    public static <T> void register(Class<T> type, AMapper<T> mapper) {
        cache.put(type, mapper);
    }

    public static <T> AMapper<T> getMapper(Type type) {
        if (type instanceof ParameterizedType) {
            return Mapper.getMapper((ParameterizedType)type);
        }
        return Mapper.getMapper((Class)type);
    }

    public static <T> AMapper<T> getMapper(Class<T> type) {
        AMapper map = cache.get(type);
        if (map != null) {
            return map;
        }
        if (type instanceof Class) {
            if (Map.class.isAssignableFrom(type)) {
                map = new DefaultMapperCollection(type);
            } else if (List.class.isAssignableFrom(type)) {
                map = new DefaultMapperCollection(type);
            }
            if (map != null) {
                cache.put(type, map);
                return map;
            }
        }
        map = type.isArray() ? new ArraysMapper.GenericMapper(type) : (List.class.isAssignableFrom(type) ? new CollectionMapper.ListClass(type) : (Map.class.isAssignableFrom(type) ? new CollectionMapper.MapClass(type) : new BeansMapper.Bean(type)));
        cache.putIfAbsent(type, map);
        return map;
    }

    public static <T> AMapper<T> getMapper(ParameterizedType type) {
        AMapper<?> map = cache.get(type);
        if (map != null) {
            return map;
        }
        Class clz = (Class)type.getRawType();
        if (List.class.isAssignableFrom(clz)) {
            map = new CollectionMapper.ListType(type);
        } else if (Map.class.isAssignableFrom(clz)) {
            map = new CollectionMapper.MapType(type);
        }
        cache.putIfAbsent(type, map);
        return map;
    }

    static {
        cache.put((Type)((Object)Date.class), BeansMapper.MAPPER_DATE);
        cache.put((Type)((Object)int[].class), ArraysMapper.MAPPER_PRIM_INT);
        cache.put((Type)((Object)Integer[].class), ArraysMapper.MAPPER_INT);
        cache.put((Type)((Object)short[].class), ArraysMapper.MAPPER_PRIM_INT);
        cache.put((Type)((Object)Short[].class), ArraysMapper.MAPPER_INT);
        cache.put((Type)((Object)long[].class), ArraysMapper.MAPPER_PRIM_LONG);
        cache.put((Type)((Object)Long[].class), ArraysMapper.MAPPER_LONG);
        cache.put((Type)((Object)byte[].class), ArraysMapper.MAPPER_PRIM_BYTE);
        cache.put((Type)((Object)Byte[].class), ArraysMapper.MAPPER_BYTE);
        cache.put((Type)((Object)char[].class), ArraysMapper.MAPPER_PRIM_CHAR);
        cache.put((Type)((Object)Character[].class), ArraysMapper.MAPPER_CHAR);
        cache.put((Type)((Object)float[].class), ArraysMapper.MAPPER_PRIM_FLOAT);
        cache.put((Type)((Object)Float[].class), ArraysMapper.MAPPER_FLOAT);
        cache.put((Type)((Object)double[].class), ArraysMapper.MAPPER_PRIM_DOUBLE);
        cache.put((Type)((Object)Double[].class), ArraysMapper.MAPPER_DOUBLE);
        cache.put((Type)((Object)boolean[].class), ArraysMapper.MAPPER_PRIM_BOOL);
        cache.put((Type)((Object)Boolean[].class), ArraysMapper.MAPPER_BOOL);
        cache.put((Type)((Object)JSONAwareEx.class), DefaultMapper.DEFAULT);
        cache.put((Type)((Object)JSONAware.class), DefaultMapper.DEFAULT);
        cache.put((Type)((Object)JSONArray.class), DefaultMapper.DEFAULT);
        cache.put((Type)((Object)JSONObject.class), DefaultMapper.DEFAULT);
    }
}

