/*
 * Decompiled with CFR 0.152.
 */
package net.minidev.json.parser;

import java.math.BigInteger;
import net.minidev.json.parser.ContainerFactory;
import net.minidev.json.parser.ContentHandler;
import net.minidev.json.parser.ParseException;

abstract class JSONBaseParser {
    protected static final char MAX_STOP = '~';
    protected static boolean[] stopArray = new boolean[126];
    protected static boolean[] stopKey = new boolean[126];
    protected static boolean[] stopValue = new boolean[126];
    protected static boolean[] stopX = new boolean[126];
    protected static boolean[] stopAll = new boolean[126];
    protected ContainerFactory containerFactory;
    protected ContentHandler handler;
    protected final MSB sb = new MSB(15);
    protected String xs;
    protected Object xo;
    protected int pos;
    protected final boolean acceptSimpleQuote;
    protected final boolean acceptNonQuote;
    protected final boolean acceptNaN;
    protected final boolean ignoreControlChar;
    protected final boolean useIntegerStorage;
    protected final boolean acceptLeadinZero;
    protected final boolean acceptUselessComma;
    protected final boolean useHiPrecisionFloat;

    public JSONBaseParser(int permissiveMode) {
        this.acceptNaN = (permissiveMode & 4) > 0;
        this.acceptNonQuote = (permissiveMode & 2) > 0;
        this.acceptSimpleQuote = (permissiveMode & 1) > 0;
        this.ignoreControlChar = (permissiveMode & 8) > 0;
        this.useIntegerStorage = (permissiveMode & 0x10) > 0;
        this.acceptLeadinZero = (permissiveMode & 0x20) > 0;
        this.acceptUselessComma = (permissiveMode & 0x40) > 0;
        this.useHiPrecisionFloat = (permissiveMode & 0x80) > 0;
    }

    public void checkLeadinZero() throws ParseException {
        int len = this.xs.length();
        if (len == 1) {
            return;
        }
        if (len == 2) {
            if (this.xs.equals("00")) {
                throw new ParseException(this.pos, 6, this.xs);
            }
            return;
        }
        char c1 = this.xs.charAt(0);
        char c2 = this.xs.charAt(1);
        if (c1 == '-') {
            char c3 = this.xs.charAt(2);
            if (c2 == '0' && c3 >= '0' && c3 <= '9') {
                throw new ParseException(this.pos, 6, this.xs);
            }
            return;
        }
        if (c1 == '0' && c2 >= '0' && c2 <= '9') {
            throw new ParseException(this.pos, 6, this.xs);
        }
    }

    public void checkControleChar() throws ParseException {
        if (this.ignoreControlChar) {
            return;
        }
        int l = this.xs.length();
        for (int i = 0; i < l; ++i) {
            char c = this.xs.charAt(i);
            if (c < '\u0000') continue;
            if (c <= '\u001f') {
                throw new ParseException(this.pos + i, 0, Character.valueOf(c));
            }
            if (c != '\u007f') continue;
            throw new ParseException(this.pos + i, 0, Character.valueOf(c));
        }
    }

    protected Number parseNumber(String s) throws ParseException {
        boolean mustCheck;
        boolean neg;
        int p = 0;
        int l = s.length();
        int max = 19;
        if (s.charAt(0) == '-') {
            ++p;
            ++max;
            neg = true;
            if (!this.acceptLeadinZero && l >= 3 && s.charAt(1) == '0') {
                throw new ParseException(this.pos, 6, s);
            }
        } else {
            neg = false;
            if (!this.acceptLeadinZero && l >= 2 && s.charAt(0) == '0') {
                throw new ParseException(this.pos, 6, s);
            }
        }
        if (l < max) {
            max = l;
            mustCheck = false;
        } else {
            if (l > max) {
                return new BigInteger(s, 10);
            }
            max = l - 1;
            mustCheck = true;
        }
        long r = 0L;
        while (p < max) {
            r = r * 10L + (long)(48 - s.charAt(p++));
        }
        if (mustCheck) {
            boolean isBig;
            if (r > -922337203685477580L) {
                isBig = false;
            } else if (r < -922337203685477580L) {
                isBig = true;
            } else if (neg) {
                isBig = s.charAt(p) > '8';
            } else {
                boolean bl = isBig = s.charAt(p) > '7';
            }
            if (isBig) {
                return new BigInteger(s, 10);
            }
            r = r * 10L + (long)(48 - s.charAt(p));
        }
        if (neg) {
            if (this.useIntegerStorage && r >= Integer.MIN_VALUE) {
                return (int)r;
            }
            return r;
        }
        r = -r;
        if (this.useIntegerStorage && r <= Integer.MAX_VALUE) {
            return (int)r;
        }
        return r;
    }

    static {
        int EOI = 26;
        JSONBaseParser.stopKey[EOI] = true;
        JSONBaseParser.stopKey[58] = true;
        JSONBaseParser.stopValue[EOI] = true;
        JSONBaseParser.stopValue[125] = true;
        JSONBaseParser.stopValue[44] = true;
        JSONBaseParser.stopArray[EOI] = true;
        JSONBaseParser.stopArray[93] = true;
        JSONBaseParser.stopArray[44] = true;
        JSONBaseParser.stopAll[58] = true;
        JSONBaseParser.stopAll[44] = true;
        JSONBaseParser.stopAll[EOI] = true;
        JSONBaseParser.stopAll[125] = true;
        JSONBaseParser.stopAll[93] = true;
    }

    public static class MSB {
        char[] b;
        int p;

        public MSB(int size) {
            this.b = new char[size];
            this.p = -1;
        }

        public void append(char c) {
            ++this.p;
            if (this.b.length <= this.p) {
                char[] t = new char[this.b.length * 2 + 1];
                System.arraycopy(this.b, 0, t, 0, this.b.length);
                this.b = t;
            }
            this.b[this.p] = c;
        }

        public void append(int c) {
            ++this.p;
            if (this.b.length <= this.p) {
                char[] t = new char[this.b.length * 2 + 1];
                System.arraycopy(this.b, 0, t, 0, this.b.length);
                this.b = t;
            }
            this.b[this.p] = (char)c;
        }

        public String toString() {
            return new String(this.b, 0, this.p + 1);
        }

        public void clear() {
            this.p = -1;
        }
    }
}

