/*
 * Decompiled with CFR 0.152.
 */
package net.minidev.json.parser;

import net.minidev.json.parser.ContainerFactory;
import net.minidev.json.parser.ContentHandler;
import net.minidev.json.parser.ContentHandlerDumy;
import net.minidev.json.parser.ParseException;

public abstract class JSONParserBase {
    protected static boolean[] stopArray = new boolean[126];
    protected static boolean[] stopKey = new boolean[126];
    protected static boolean[] stopValue = new boolean[126];
    protected static boolean[] stopX = new boolean[126];
    public static final int ACCEPT_SIMPLE_QUOTE = 1;
    public static final int ACCEPT_NON_QUOTE = 2;
    public static final int ACCEPT_NAN = 4;
    public static final int IGNORE_CONTROL_CHAR = 8;
    public static final int USE_INTEGER_STORAGE = 16;
    public static final int ACCEPT_LEADING_ZERO = 32;
    public static final int ACCEPT_USELESS_COMMA = 64;
    public static final int MODE_PERMISSIVE = -1;
    public static final int MODE_RFC4627 = 16;
    public static final int MODE_JSON_SIMPLE = 64;
    protected ContainerFactory containerFactory;
    protected ContentHandler handler = ContentHandlerDumy.HANDLER;
    protected final MSB sb = new MSB(15);
    protected String xs;
    protected Object xo;
    protected int pos;
    protected final boolean acceptSimpleQuote;
    protected final boolean acceptNonQuote;
    protected final boolean acceptNaN;
    protected final boolean ignoreControlChar;
    protected final boolean useIntegerStorage;
    protected final boolean acceptLeadinZero;
    protected final boolean acceptUselessComma;

    public void setHandler(ContentHandler handler) {
        this.handler = handler;
    }

    public JSONParserBase(int permissiveMode) {
        this.acceptNaN = (permissiveMode & 4) > 0;
        this.acceptNonQuote = (permissiveMode & 2) > 0;
        this.acceptSimpleQuote = (permissiveMode & 1) > 0;
        this.ignoreControlChar = (permissiveMode & 8) > 0;
        this.useIntegerStorage = (permissiveMode & 0x10) > 0;
        this.acceptLeadinZero = (permissiveMode & 0x20) > 0;
        this.acceptUselessComma = (permissiveMode & 0x40) > 0;
    }

    public void checkControleChar() throws ParseException {
        if (this.ignoreControlChar) {
            return;
        }
        int l = this.xs.length();
        for (int i = 0; i < l; ++i) {
            char c = this.xs.charAt(i);
            if (c < '\u0000') continue;
            if (c <= '\u001f') {
                throw new ParseException(this.pos + i, 0, Character.valueOf(c));
            }
            if (c != '\u007f') continue;
            throw new ParseException(this.pos + i, 0, Character.valueOf(c));
        }
    }

    static {
        JSONParserBase.stopKey[58] = true;
        JSONParserBase.stopValue[125] = true;
        JSONParserBase.stopValue[44] = true;
        JSONParserBase.stopArray[93] = true;
        JSONParserBase.stopArray[44] = true;
    }

    public static class MSB {
        char[] b;
        int p;

        public MSB(int size) {
            this.b = new char[size];
            this.p = -1;
        }

        public void append(char c) {
            ++this.p;
            if (this.b.length <= this.p) {
                char[] t = new char[this.b.length * 2 + 1];
                System.arraycopy(this.b, 0, t, 0, this.b.length);
                this.b = t;
            }
            this.b[this.p] = c;
        }

        public void append(int c) {
            ++this.p;
            if (this.b.length <= this.p) {
                char[] t = new char[this.b.length * 2 + 1];
                System.arraycopy(this.b, 0, t, 0, this.b.length);
                this.b = t;
            }
            this.b[this.p] = (char)c;
        }

        public String toString() {
            return new String(this.b, 0, this.p + 1);
        }

        public void clear() {
            this.p = -1;
        }
    }
}

