package net.minidev.json.parser;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;

/**
 * Container factory for creating containers for JSON object and JSON array.
 * 
 * @author Uriel Chemouni <uchemouni@gmail.com>
 */
public interface ContainerFactory {
	/**
	 * @return A Map instance to build JSON object.
	 */
	public Map<String, Object> createObjectContainer();

	/**
	 * @return A List instance to store JSON array.
	 */
	public List<Object> creatArrayContainer();

	/**
	 * Default factory
	 */
	public final static ContainerFactory FACTORY_SIMPLE = new ContainerFactory() {

		@Override
		public Map<String, Object> createObjectContainer() {
			return new JSONObject();
		}

		@Override
		public List<Object> creatArrayContainer() {
			return new JSONArray();
		}
	};
	
	public final static ContainerFactory FACTORY_ORDERED = new ContainerFactory() {

		@Override
		public Map<String, Object> createObjectContainer() {
			return new LinkedHashMap<String, Object>();
		}

		@Override
		public List<Object> creatArrayContainer() {
			return new JSONArray();
		}
	};
	
}
