/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.action;

import cn.hutool.core.io.FileTypeUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.IdUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import net.mingsoft.base.entity.ResultData;
import net.mingsoft.basic.action.BaseAction;
import net.mingsoft.basic.bean.UploadConfigBean;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.basic.util.ConfigUtil;
import net.mingsoft.config.MSProperties;
import org.apache.commons.lang3.StringUtils;

public abstract class BaseFileAction
extends BaseAction {
    public ResultData upload(UploadConfigBean config) throws IOException {
        return this.upload(config, false);
    }

    public ResultData upload(UploadConfigBean config, boolean isRootUploadPath) throws IOException {
        String realPath;
        String uploadPath = ConfigUtil.getString("\u6587\u4ef6\u4e0a\u4f20\u914d\u7f6e", "uploadPath", MSProperties.upload.path);
        String uploadMapping = ConfigUtil.getString("\u6587\u4ef6\u4e0a\u4f20\u914d\u7f6e", "uploadMapping", MSProperties.upload.mapping);
        Object fileName = config.getFile().getOriginalFilename();
        String fileType = FileUtil.getSuffix((String)config.getFile().getOriginalFilename());
        if (StringUtils.isBlank((CharSequence)fileType)) {
            InputStream inputStream = config.getFile().getInputStream();
            fileType = FileTypeUtil.getType((InputStream)inputStream);
            inputStream.close();
        }
        boolean isReal = new File(uploadPath).isAbsolute();
        String string = isRootUploadPath ? BasicUtil.getRealPath("") : (realPath = isReal ? uploadPath : BasicUtil.getRealPath(uploadPath));
        if (!config.isRename()) {
            if (((String)fileName).endsWith(".") && System.getProperty("os.name").startsWith("Windows")) {
                this.LOG.info("\u6587\u4ef6\u7c7b\u578b\u88ab\u62d2\u7edd:{}", fileName);
                return ResultData.build().error(this.getResString("err.error", new String[]{this.getResString("file.type")}));
            }
        } else {
            fileName = IdUtil.getSnowflake().nextId() + "." + fileType;
        }
        String uploadFolder = realPath + File.separator;
        if (StringUtils.isNotBlank((CharSequence)config.getUploadPath())) {
            uploadFolder = uploadFolder + config.getUploadPath() + File.separator;
        }
        File saveFolder = new File(uploadFolder);
        File saveFile = new File(uploadFolder, (String)fileName);
        if (!saveFolder.exists()) {
            FileUtil.mkdir((File)saveFolder);
        }
        config.getFile().transferTo(saveFile);
        String path = (isRootUploadPath ? "" : uploadMapping.replace("**", "")) + uploadFolder.replace(realPath, "") + "/" + (String)fileName;
        return ResultData.build().success((Object)new File("/" + path).getPath().replace("\\", "/").replace("//", "/"));
    }

    public ResultData uploadTemplate(UploadConfigBean config) throws IOException {
        String uploadTemplatePath = ConfigUtil.getString("\u6587\u4ef6\u4e0a\u4f20\u914d\u7f6e", "uploadTemplate", MSProperties.upload.template);
        Object fileName = config.getFile().getOriginalFilename();
        InputStream inputStream = config.getFile().getInputStream();
        String fileType = FileTypeUtil.getType((InputStream)inputStream);
        inputStream.close();
        boolean isReal = new File(uploadTemplatePath).isAbsolute();
        String realPath = null;
        realPath = !isReal ? BasicUtil.getRealPath("") : uploadTemplatePath;
        if (!config.isRename()) {
            if (((String)fileName).endsWith(".") && System.getProperty("os.name").startsWith("Windows")) {
                this.LOG.info("\u6587\u4ef6\u7c7b\u578b\u88ab\u62d2\u7edd:{}", fileName);
                return ResultData.build().error(this.getResString("err.error", new String[]{this.getResString("file.type")}));
            }
        } else {
            fileName = System.currentTimeMillis() + "." + fileType;
        }
        String uploadFolder = realPath + File.separator;
        uploadFolder = StringUtils.isNotBlank((CharSequence)config.getUploadPath()) && new File(config.getUploadPath()).isAbsolute() ? config.getUploadPath() + File.separator : uploadFolder + config.getUploadPath() + File.separator;
        File saveFolder = new File(uploadFolder);
        File saveFile = new File(uploadFolder, (String)fileName);
        if (!saveFolder.exists()) {
            FileUtil.mkdir((File)saveFolder);
        }
        config.getFile().transferTo(saveFile);
        String path = uploadFolder.replace(realPath, "") + "/" + (String)fileName;
        return ResultData.build().success((Object)new File("/" + path).getPath().replace("\\", "/").replace("//", "/"));
    }
}

