/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.exception;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Path;
import net.mingsoft.basic.constant.ErrorCodeEnum;
import net.mingsoft.basic.util.BasicUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.UnauthorizedException;
import org.apache.shiro.session.ExpiredSessionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.NoHandlerFoundException;
import org.springframework.web.servlet.mvc.support.DefaultHandlerExceptionResolver;

@ControllerAdvice
public class GlobalExceptionResolver
extends DefaultHandlerExceptionResolver {
    protected final Logger LOG = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    @ExceptionHandler(value={Exception.class})
    public ModelAndView handleException(HttpServletRequest request, HttpServletResponse response, Exception e) {
        HashMap<String, ErrorCodeEnum> map = new HashMap<String, ErrorCodeEnum>();
        map.put("code", ErrorCodeEnum.SERVER_ERROR);
        return this.getModelAndView(request, response, map, e);
    }

    @ExceptionHandler(value={NoHandlerFoundException.class})
    public ModelAndView handleNoHandlerFoundException(HttpServletRequest request, HttpServletResponse response, Exception e) {
        HashMap<String, ErrorCodeEnum> map = new HashMap<String, ErrorCodeEnum>();
        map.put("code", ErrorCodeEnum.CLIENT_NOT_FIND);
        return this.getModelAndView(request, response, map, e);
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    public ModelAndView handleMissingServletRequestParameterException(HttpServletRequest request, HttpServletResponse response, Exception e) {
        HashMap<String, ErrorCodeEnum> map = new HashMap<String, ErrorCodeEnum>();
        map.put("code", ErrorCodeEnum.CLIENT_NOT_FIND);
        return this.getModelAndView(request, response, map, e);
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public ModelAndView handleHttpRequestMethodNotSupportedException(HttpServletRequest request, HttpServletResponse response, Exception e) {
        HashMap<String, ErrorCodeEnum> map = new HashMap<String, ErrorCodeEnum>();
        map.put("code", ErrorCodeEnum.CLIENT_NOT_FIND);
        return this.getModelAndView(request, response, map, e);
    }

    @ExceptionHandler(value={BindException.class})
    public ModelAndView validExceptionHandler(HttpServletRequest request, HttpServletResponse response, BindException e) {
        StringBuilder message = new StringBuilder();
        List fieldErrors = e.getBindingResult().getFieldErrors();
        for (FieldError error : fieldErrors) {
            message.append(error.getField()).append(error.getDefaultMessage()).append(",");
        }
        message = new StringBuilder(message.substring(0, message.length() - 1));
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("msg", message.toString());
        map.put("cls", e.getStackTrace()[0] + "");
        map.put("url", request.getServletPath());
        map.put("code", (Object)ErrorCodeEnum.CLIENT_REQUEST);
        map.put("result", false);
        map.put("msg", message.toString());
        map.put("exc", e.getClass());
        return this.getModelAndView(request, response, map, null);
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    public ModelAndView handleConstraintViolationException(HttpServletRequest request, HttpServletResponse response, ConstraintViolationException e) {
        StringBuilder message = new StringBuilder();
        Set violations = e.getConstraintViolations();
        for (ConstraintViolation violation : violations) {
            Path path = violation.getPropertyPath();
            String[] pathArr = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)path.toString(), (String)".");
            message.append(pathArr[1]).append(violation.getMessage()).append(",");
        }
        message = new StringBuilder(message.substring(0, message.length() - 1));
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("msg", message.toString());
        map.put("code", (Object)ErrorCodeEnum.CLIENT_REQUEST);
        map.put("cls", e.getStackTrace()[0] + "");
        map.put("url", request.getServletPath());
        map.put("exc", e.getClass());
        return this.getModelAndView(request, response, map, null);
    }

    @ExceptionHandler(value={UnauthorizedException.class})
    public ModelAndView handleUnauthorizedException(HttpServletRequest request, HttpServletResponse response, UnauthorizedException e) {
        HashMap<String, ErrorCodeEnum> map = new HashMap<String, ErrorCodeEnum>();
        map.put("code", ErrorCodeEnum.CLIENT_UNAUTHORIZED);
        return this.getModelAndView(request, response, map, (Exception)e);
    }

    @ExceptionHandler(value={AuthenticationException.class})
    public ModelAndView handleAuthenticationException(HttpServletRequest request, HttpServletResponse response, AuthenticationException e) {
        HashMap<String, ErrorCodeEnum> map = new HashMap<String, ErrorCodeEnum>();
        map.put("code", ErrorCodeEnum.CLIENT_NOT_FIND);
        return this.getModelAndView(request, response, map, (Exception)e);
    }

    @ExceptionHandler(value={AuthorizationException.class})
    public ModelAndView handleAuthorizationException(HttpServletRequest request, HttpServletResponse response, AuthorizationException e) {
        this.LOG.debug("AuthorizationException", (Throwable)e);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cls", e.getStackTrace()[0] + "");
        map.put("url", request.getServletPath());
        map.put("code", (Object)ErrorCodeEnum.CLIENT_NOT_FIND);
        map.put("msg", e.getStackTrace());
        map.put("exc", e.getClass());
        return this.getModelAndView(request, response, map, null);
    }

    @ExceptionHandler(value={ExpiredSessionException.class})
    public ModelAndView handleExpiredSessionException(HttpServletRequest request, HttpServletResponse response, ExpiredSessionException e) {
        this.LOG.debug("ExpiredSessionException", (Throwable)e);
        HashMap<String, ErrorCodeEnum> map = new HashMap<String, ErrorCodeEnum>();
        map.put("code", ErrorCodeEnum.CLIENT_UNAUTHORIZED);
        return this.getModelAndView(request, response, map, (Exception)e);
    }

    private ModelAndView getModelAndView(HttpServletRequest request, HttpServletResponse response, Map map, Exception e) {
        if (ObjectUtil.isNotNull((Object)e)) {
            this.LOG.debug("handleException", (Throwable)e);
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter((Writer)sw, true));
            map.put("cls", e.getStackTrace()[0] + "");
            map.put("url", request.getServletPath());
            map.put("msg", sw.toString());
            map.put("exc", e.getClass());
        }
        map.put("result", false);
        if (BasicUtil.isAjaxRequest(request)) {
            try {
                response.setContentType("application/json;charset=UTF-8");
                PrintWriter writer = response.getWriter();
                writer.write(JSONObject.toJSONString((Object)map));
                writer.flush();
                writer.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        } else {
            return new ModelAndView("/error/index", map);
        }
        return null;
    }
}

