/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.action;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.base.entity.BaseEntity;
import net.mingsoft.base.entity.ResultData;
import net.mingsoft.basic.action.BaseAction;
import net.mingsoft.basic.annotation.LogAnn;
import net.mingsoft.basic.bean.EUListBean;
import net.mingsoft.basic.biz.IFileBiz;
import net.mingsoft.basic.constant.e.BusinessTypeEnum;
import net.mingsoft.basic.entity.FileEntity;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.basic.util.StringUtil;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import springfox.documentation.annotations.ApiIgnore;

@Api(value="\u57fa\u7840\u6587\u4ef6\u8868\u7ba1\u7406\u63a7\u5236\u5c42")
@Controller(value="netFileAction")
@RequestMapping(value={"/${ms.manager.path}/basic/file"})
public class FileAction
extends BaseAction {
    @Resource(name="fileBizImpl")
    private IFileBiz fileBiz;

    @ApiOperation(value="\u8fd4\u56de\u4e3b\u754c\u9762index")
    @GetMapping(value={"/index"})
    public String index(HttpServletResponse response, HttpServletRequest request) {
        return "/basic/file/index";
    }

    @ApiOperation(value="\u67e5\u8be2\u57fa\u7840\u6587\u4ef6\u8868\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="categoryId", value="\u6587\u4ef6\u5206\u7c7b\u7f16\u53f7", required=false, paramType="query"), @ApiImplicitParam(name="fileName", value="\u6587\u4ef6\u540d\u79f0", required=false, paramType="query"), @ApiImplicitParam(name="fileUrl", value="\u6587\u4ef6\u94fe\u63a5", required=false, paramType="query"), @ApiImplicitParam(name="fileSize", value="\u6587\u4ef6\u5927\u5c0f", required=false, paramType="query"), @ApiImplicitParam(name="fileJson", value="\u6587\u4ef6\u8be6\u60c5Json\u6570\u636e", required=false, paramType="query"), @ApiImplicitParam(name="fileType", value="\u6587\u4ef6\u7c7b\u578b\uff1a\u56fe\u7247\u3001\u97f3\u9891\u3001\u89c6\u9891\u7b49", required=false, paramType="query"), @ApiImplicitParam(name="isChild", value="\u5b50\u4e1a\u52a1", required=false, paramType="query")})
    @GetMapping(value={"/list"})
    @ResponseBody
    public ResultData list(@ModelAttribute @ApiIgnore FileEntity file, HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model, BindingResult result) {
        BasicUtil.startPage();
        List fileList = this.fileBiz.query(file);
        return ResultData.build().success((Object)new EUListBean(fileList, (int)BasicUtil.endPage(fileList).getTotal()));
    }

    @ApiOperation(value="\u8fd4\u56de\u7f16\u8f91\u754c\u9762file_form")
    @ApiImplicitParam(name="id", value="\u6587\u4ef6\u7f16\u53f7", required=true, paramType="query")
    @GetMapping(value={"/form"})
    public String form(@ModelAttribute @ApiIgnore FileEntity file, HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model) {
        if (file.getId() != null) {
            BaseEntity fileEntity = this.fileBiz.getEntity(Integer.parseInt(file.getId()));
            model.addAttribute("fileEntity", (Object)fileEntity);
        }
        return "/basic/file/form";
    }

    @ApiOperation(value="\u83b7\u53d6\u57fa\u7840\u6587\u4ef6\u8868")
    @ApiImplicitParam(name="id", value="\u6587\u4ef6\u7f16\u53f7", required=true, paramType="query")
    @GetMapping(value={"/get"})
    @ResponseBody
    public ResultData get(@ModelAttribute @ApiIgnore FileEntity file, HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model) {
        if (file.getId() == null) {
            return null;
        }
        FileEntity _file = (FileEntity)this.fileBiz.getEntity(Integer.parseInt(file.getId()));
        return ResultData.build().success((Object)_file);
    }

    @ApiOperation(value="\u4fdd\u5b58\u57fa\u7840\u6587\u4ef6\u8868\u5b9e\u4f53")
    @ApiImplicitParams(value={@ApiImplicitParam(name="categoryId", value="\u6587\u4ef6\u5206\u7c7b\u7f16\u53f7", required=true, paramType="query"), @ApiImplicitParam(name="fileName", value="\u6587\u4ef6\u540d\u79f0", required=true, paramType="query"), @ApiImplicitParam(name="fileUrl", value="\u6587\u4ef6\u94fe\u63a5", required=true, paramType="query"), @ApiImplicitParam(name="fileSize", value="\u6587\u4ef6\u5927\u5c0f", required=true, paramType="query"), @ApiImplicitParam(name="fileJson", value="\u6587\u4ef6\u8be6\u60c5Json\u6570\u636e", required=true, paramType="query"), @ApiImplicitParam(name="fileType", value="\u6587\u4ef6\u7c7b\u578b\uff1a\u56fe\u7247\u3001\u97f3\u9891\u3001\u89c6\u9891\u7b49", required=true, paramType="query"), @ApiImplicitParam(name="isChild", value="\u5b50\u4e1a\u52a1", required=true, paramType="query")})
    @LogAnn(title="\u4fdd\u5b58\u57fa\u7840\u6587\u4ef6\u8868\u5b9e\u4f53", businessType=BusinessTypeEnum.INSERT)
    @PostMapping(value={"/save"})
    @ResponseBody
    @RequiresPermissions(value={"file:save"})
    public ResultData save(@ModelAttribute @ApiIgnore FileEntity file, HttpServletResponse response, HttpServletRequest request, BindingResult result) {
        if (StringUtil.isBlank(file.getCategoryId())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("category.id")}));
        }
        if (!StringUtil.checkLength(file.getCategoryId() + "", 1, 11)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("category.id"), "1", "11"}));
        }
        if (StringUtil.isBlank(file.getFileName())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("file.name")}));
        }
        if (!StringUtil.checkLength(file.getFileName() + "", 1, 200)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("file.name"), "1", "200"}));
        }
        if (StringUtil.isBlank(file.getFileUrl())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("file.url")}));
        }
        if (!StringUtil.checkLength(file.getFileUrl() + "", 1, 500)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("file.url"), "1", "500"}));
        }
        if (StringUtil.isBlank(file.getFileSize())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("file.size")}));
        }
        if (!StringUtil.checkLength(file.getFileSize() + "", 1, 11)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("file.size"), "1", "11"}));
        }
        if (StringUtil.isBlank(file.getFileJson())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("file.json")}));
        }
        if (!StringUtil.checkLength(file.getFileJson() + "", 1, 500)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("file.json"), "1", "500"}));
        }
        if (StringUtil.isBlank(file.getFileType())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("file.type")}));
        }
        if (!StringUtil.checkLength(file.getFileType() + "", 1, 50)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("file.type"), "1", "50"}));
        }
        if (StringUtil.isBlank(file.getIsChild())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("is.child")}));
        }
        if (!StringUtil.checkLength(file.getIsChild() + "", 1, 50)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("is.child"), "1", "50"}));
        }
        this.fileBiz.saveEntity(file);
        return ResultData.build().success((Object)file);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u57fa\u7840\u6587\u4ef6\u8868")
    @LogAnn(title="\u6279\u91cf\u5220\u9664\u57fa\u7840\u6587\u4ef6\u8868", businessType=BusinessTypeEnum.DELETE)
    @PostMapping(value={"/delete"})
    @ResponseBody
    @RequiresPermissions(value={"file:del"})
    public ResultData delete(@RequestBody List<FileEntity> files, HttpServletResponse response, HttpServletRequest request) {
        int[] ids = new int[files.size()];
        for (int i = 0; i < files.size(); ++i) {
            ids[i] = Integer.parseInt(files.get(i).getId());
        }
        this.fileBiz.delete(ids);
        return ResultData.build().success();
    }

    @ApiOperation(value="\u66f4\u65b0\u57fa\u7840\u6587\u4ef6\u8868\u4fe1\u606f\u57fa\u7840\u6587\u4ef6\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u6587\u4ef6\u7f16\u53f7", required=true, paramType="query"), @ApiImplicitParam(name="categoryId", value="\u6587\u4ef6\u5206\u7c7b\u7f16\u53f7", required=true, paramType="query"), @ApiImplicitParam(name="fileName", value="\u6587\u4ef6\u540d\u79f0", required=true, paramType="query"), @ApiImplicitParam(name="fileUrl", value="\u6587\u4ef6\u94fe\u63a5", required=true, paramType="query"), @ApiImplicitParam(name="fileSize", value="\u6587\u4ef6\u5927\u5c0f", required=true, paramType="query"), @ApiImplicitParam(name="fileJson", value="\u6587\u4ef6\u8be6\u60c5Json\u6570\u636e", required=true, paramType="query"), @ApiImplicitParam(name="fileType", value="\u6587\u4ef6\u7c7b\u578b\uff1a\u56fe\u7247\u3001\u97f3\u9891\u3001\u89c6\u9891\u7b49", required=true, paramType="query"), @ApiImplicitParam(name="isChild", value="\u5b50\u4e1a\u52a1", required=true, paramType="query")})
    @LogAnn(title="\u66f4\u65b0\u57fa\u7840\u6587\u4ef6\u8868\u4fe1\u606f\u57fa\u7840\u6587\u4ef6\u8868", businessType=BusinessTypeEnum.UPDATE)
    @PostMapping(value={"/update"})
    @ResponseBody
    @RequiresPermissions(value={"file:update"})
    public ResultData update(@ModelAttribute @ApiIgnore FileEntity file, HttpServletResponse response, HttpServletRequest request) {
        if (StringUtil.isBlank(file.getId())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("file.id")}));
        }
        if (!StringUtil.checkLength(file.getId() + "", 1, 11)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("file.id"), "1", "11"}));
        }
        if (StringUtil.isBlank(file.getCategoryId())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("category.id")}));
        }
        if (!StringUtil.checkLength(file.getCategoryId() + "", 1, 11)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("category.id"), "1", "11"}));
        }
        if (StringUtil.isBlank(file.getFileName())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("file.name")}));
        }
        if (!StringUtil.checkLength(file.getFileName() + "", 1, 200)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("file.name"), "1", "200"}));
        }
        if (StringUtil.isBlank(file.getFileUrl())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("file.url")}));
        }
        if (!StringUtil.checkLength(file.getFileUrl() + "", 1, 500)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("file.url"), "1", "500"}));
        }
        if (StringUtil.isBlank(file.getFileSize())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("file.size")}));
        }
        if (!StringUtil.checkLength(file.getFileSize() + "", 1, 11)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("file.size"), "1", "11"}));
        }
        if (StringUtil.isBlank(file.getFileJson())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("file.json")}));
        }
        if (!StringUtil.checkLength(file.getFileJson() + "", 1, 500)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("file.json"), "1", "500"}));
        }
        if (StringUtil.isBlank(file.getFileType())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("file.type")}));
        }
        if (!StringUtil.checkLength(file.getFileType() + "", 1, 50)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("file.type"), "1", "50"}));
        }
        if (StringUtil.isBlank(file.getIsChild())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("is.child")}));
        }
        if (!StringUtil.checkLength(file.getIsChild() + "", 1, 50)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("is.child"), "1", "50"}));
        }
        this.fileBiz.updateEntity(file);
        return ResultData.build().success((Object)file);
    }
}

