/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import net.masterthought.cucumber.Configuration;
import net.masterthought.cucumber.ReportParser;
import net.masterthought.cucumber.ReportResult;
import net.masterthought.cucumber.ValidationException;
import net.masterthought.cucumber.generators.ErrorPage;
import net.masterthought.cucumber.generators.FailuresOverviewPage;
import net.masterthought.cucumber.generators.FeatureReportPage;
import net.masterthought.cucumber.generators.FeaturesOverviewPage;
import net.masterthought.cucumber.generators.StepsOverviewPage;
import net.masterthought.cucumber.generators.TagReportPage;
import net.masterthought.cucumber.generators.TagsOverviewPage;
import net.masterthought.cucumber.json.Feature;
import net.masterthought.cucumber.json.support.TagObject;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReportBuilder {
    private static final Logger LOG = LogManager.getLogger(ReportBuilder.class);
    public static final String HOME_PAGE = "feature-overview.html";
    public static final String BASE_DIRECTORY = "cucumber-html-reports";
    private ReportResult reportResult;
    private final ReportParser reportParser;
    private Configuration configuration;
    private List<String> jsonFiles;

    public ReportBuilder(List<String> jsonFiles, Configuration configuration) {
        this.jsonFiles = jsonFiles;
        this.configuration = configuration;
        this.reportParser = new ReportParser(configuration);
    }

    public void generateReports() {
        try {
            this.copyStaticResources();
            this.createEmbeddingsDirectory();
            List<Feature> features = this.reportParser.parseJsonFiles(this.jsonFiles);
            this.reportResult = new ReportResult(features);
            this.generateAllPages();
        }
        catch (Exception e) {
            this.generateErrorPage(e);
        }
    }

    public boolean hasBuildPassed() {
        return this.reportResult != null && this.reportResult.getAllFailedFeatures() == 0;
    }

    private void copyStaticResources() {
        this.copyResources("css", "reporting.css", "bootstrap.min.css", "font-awesome.min.css");
        this.copyResources("js", "jquery.min.js", "jquery.tablesorter.min.js", "bootstrap.min.js", "Chart.min.js");
        this.copyResources("fonts", "FontAwesome.otf", "fontawesome-webfont.svg", "fontawesome-webfont.woff", "fontawesome-webfont.eot", "fontawesome-webfont.ttf", "fontawesome-webfont.woff2", "glyphicons-halflings-regular.eot", "glyphicons-halflings-regular.eot", "glyphicons-halflings-regular.woff2", "glyphicons-halflings-regular.woff", "glyphicons-halflings-regular.ttf", "glyphicons-halflings-regular.svg");
        this.copyResources("images", "favicon.png");
    }

    private void createEmbeddingsDirectory() {
        this.configuration.getEmbeddingDirectory().mkdirs();
    }

    private void copyResources(String resourceLocation, String ... resources) {
        for (String resource : resources) {
            File tempFile = new File(this.configuration.getReportDirectory().getAbsoluteFile(), BASE_DIRECTORY + File.separatorChar + resourceLocation + File.separatorChar + resource);
            try {
                FileUtils.copyInputStreamToFile((InputStream)this.getClass().getResourceAsStream("/" + resourceLocation + "/" + resource), (File)tempFile);
            }
            catch (IOException e) {
                throw new ValidationException(e);
            }
        }
    }

    private void generateAllPages() {
        new FeaturesOverviewPage(this.reportResult, this.configuration).generatePage();
        for (Feature feature : this.reportResult.getAllFeatures()) {
            new FeatureReportPage(this.reportResult, this.configuration, feature).generatePage();
        }
        new TagsOverviewPage(this.reportResult, this.configuration).generatePage();
        for (TagObject tagObject : this.reportResult.getAllTags()) {
            new TagReportPage(this.reportResult, this.configuration, tagObject).generatePage();
        }
        new StepsOverviewPage(this.reportResult, this.configuration).generatePage();
        new FailuresOverviewPage(this.reportResult, this.configuration).generatePage();
    }

    private void generateErrorPage(Exception exception) {
        LOG.info((Object)exception);
        ErrorPage errorPage = new ErrorPage(this.reportResult, this.configuration, exception, this.jsonFiles);
        errorPage.generatePage();
    }
}

