/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.composite;

import ch.qos.logback.core.spi.DeferredProcessingAware;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Objects;
import java.util.TimeZone;
import java.util.function.Function;
import net.logstash.logback.composite.AbstractFieldJsonProvider;
import net.logstash.logback.composite.FastISOTimestampFormatter;
import net.logstash.logback.composite.FieldNamesAware;
import net.logstash.logback.composite.JsonWritingUtils;
import net.logstash.logback.fieldnames.LogstashCommonFieldNames;
import net.logstash.logback.util.TimeZoneUtils;

public abstract class AbstractFormattedTimestampJsonProvider<Event extends DeferredProcessingAware, FieldNames extends LogstashCommonFieldNames>
extends AbstractFieldJsonProvider<Event>
implements FieldNamesAware<FieldNames> {
    public static final String FIELD_TIMESTAMP = "@timestamp";
    public static final String UNIX_TIMESTAMP_AS_NUMBER = "[UNIX_TIMESTAMP_AS_NUMBER]";
    public static final String UNIX_TIMESTAMP_AS_STRING = "[UNIX_TIMESTAMP_AS_STRING]";
    private static final String DEFAULT_PATTERN = "[ISO_OFFSET_DATE_TIME]";
    public static final String DEFAULT_TIMEZONE_KEYWORD = "[DEFAULT]";
    private String pattern = "[ISO_OFFSET_DATE_TIME]";
    private TimeZone timeZone = TimeZone.getDefault();
    private TimestampWriter timestampWriter;

    public AbstractFormattedTimestampJsonProvider() {
        this.setFieldName(FIELD_TIMESTAMP);
        this.updateTimestampWriter();
    }

    @Override
    public void setFieldNames(FieldNames fieldNames) {
        this.setFieldName(((LogstashCommonFieldNames)fieldNames).getTimestamp());
    }

    @Override
    public void writeTo(JsonGenerator generator, Event event) throws IOException {
        this.timestampWriter.writeTo(generator, this.getFieldName(), this.getTimestampAsInstant(event));
    }

    protected String getFormattedTimestamp(Event event) {
        return this.timestampWriter.getTimestampAsString(this.getTimestampAsInstant(event));
    }

    protected abstract Instant getTimestampAsInstant(Event var1);

    private void updateTimestampWriter() {
        this.timestampWriter = this.createTimestampWriter();
    }

    private TimestampWriter createTimestampWriter() {
        if (UNIX_TIMESTAMP_AS_NUMBER.equals(this.pattern)) {
            return new NumberTimestampWriter();
        }
        if (UNIX_TIMESTAMP_AS_STRING.equals(this.pattern)) {
            return StringFormatterWriter.with(tstamp -> Long.toString(tstamp.toEpochMilli()));
        }
        if (this.pattern.startsWith("[") && this.pattern.endsWith("]")) {
            String constant = this.pattern.substring(1, this.pattern.length() - 1);
            ZoneId zone = this.timeZone.toZoneId();
            if ("ISO_OFFSET_DATE_TIME".equals(constant)) {
                return StringFormatterWriter.with(FastISOTimestampFormatter.isoOffsetDateTime(zone));
            }
            if ("ISO_ZONED_DATE_TIME".equals(constant)) {
                return StringFormatterWriter.with(FastISOTimestampFormatter.isoZonedDateTime(zone));
            }
            if ("ISO_LOCAL_DATE_TIME".equals(constant)) {
                return StringFormatterWriter.with(FastISOTimestampFormatter.isoLocalDateTime(zone));
            }
            if ("ISO_DATE_TIME".equals(constant)) {
                return StringFormatterWriter.with(FastISOTimestampFormatter.isoDateTime(zone));
            }
            if ("ISO_INSTANT".equals(constant)) {
                return StringFormatterWriter.with(FastISOTimestampFormatter.isoInstant(zone));
            }
            DateTimeFormatter formatter = this.getStandardDateTimeFormatter(constant).withZone(zone);
            return StringFormatterWriter.with(formatter);
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(this.pattern).withZone(this.timeZone.toZoneId());
        return StringFormatterWriter.with(formatter);
    }

    private DateTimeFormatter getStandardDateTimeFormatter(String name) {
        try {
            Field field = DateTimeFormatter.class.getField(name);
            if (Modifier.isStatic(field.getModifiers()) && Modifier.isFinal(field.getModifiers()) && field.getType().equals(DateTimeFormatter.class)) {
                return (DateTimeFormatter)field.get(null);
            }
            throw new IllegalArgumentException(String.format("Field named %s in %s is not a constant %s", name, DateTimeFormatter.class, DateTimeFormatter.class));
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(String.format("Unable to get value of constant named %s in %s", name, DateTimeFormatter.class), e);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException(String.format("No constant named %s found in %s", name, DateTimeFormatter.class), e);
        }
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
        this.updateTimestampWriter();
    }

    public String getTimeZone() {
        return this.timeZone.getID();
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone == null || timeZone.trim().isEmpty() || DEFAULT_TIMEZONE_KEYWORD.equalsIgnoreCase(timeZone) ? TimeZone.getDefault() : TimeZoneUtils.parseTimeZone(timeZone);
        this.updateTimestampWriter();
    }

    protected static interface TimestampWriter {
        public void writeTo(JsonGenerator var1, String var2, Instant var3) throws IOException;

        public String getTimestampAsString(Instant var1);
    }

    protected static class NumberTimestampWriter
    implements TimestampWriter {
        protected NumberTimestampWriter() {
        }

        @Override
        public void writeTo(JsonGenerator generator, String fieldName, Instant timestamp) throws IOException {
            JsonWritingUtils.writeNumberField(generator, fieldName, timestamp.toEpochMilli());
        }

        @Override
        public String getTimestampAsString(Instant timestamp) {
            return Long.toString(timestamp.toEpochMilli());
        }
    }

    protected static class StringFormatterWriter
    implements TimestampWriter {
        private final Function<Instant, String> provider;

        StringFormatterWriter(Function<Instant, String> provider) {
            this.provider = Objects.requireNonNull(provider);
        }

        @Override
        public void writeTo(JsonGenerator generator, String fieldName, Instant timestamp) throws IOException {
            JsonWritingUtils.writeStringField(generator, fieldName, this.getTimestampAsString(timestamp));
        }

        @Override
        public String getTimestampAsString(Instant timestamp) {
            return this.provider.apply(timestamp);
        }

        static StringFormatterWriter with(DateTimeFormatter formatter) {
            return new StringFormatterWriter(tstamp -> formatter.format((TemporalAccessor)tstamp));
        }

        static StringFormatterWriter with(FastISOTimestampFormatter formatter) {
            return new StringFormatterWriter(formatter::format);
        }

        static StringFormatterWriter with(Function<Instant, String> formatter) {
            return new StringFormatterWriter(formatter);
        }
    }
}

