/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.appender;

import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.joran.spi.DefaultClass;
import ch.qos.logback.core.net.ssl.ConfigurableSSLSocketFactory;
import ch.qos.logback.core.net.ssl.SSLConfigurable;
import ch.qos.logback.core.net.ssl.SSLConfigurableSocket;
import ch.qos.logback.core.net.ssl.SSLConfiguration;
import ch.qos.logback.core.net.ssl.SSLParametersConfiguration;
import ch.qos.logback.core.spi.ContextAware;
import ch.qos.logback.core.spi.DeferredProcessingAware;
import ch.qos.logback.core.util.CloseUtil;
import ch.qos.logback.core.util.Duration;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import net.logstash.logback.appender.AbstractLogstashTcpSocketAppender;
import net.logstash.logback.appender.AsyncDisruptorAppender;
import net.logstash.logback.appender.NotConnectedException;
import net.logstash.logback.appender.ShutdownInProgressException;
import net.logstash.logback.appender.destination.DelegateDestinationConnectionStrategy;
import net.logstash.logback.appender.destination.DestinationConnectionStrategy;
import net.logstash.logback.appender.destination.DestinationParser;
import net.logstash.logback.appender.destination.PreferPrimaryDestinationConnectionStrategy;
import net.logstash.logback.appender.listener.TcpAppenderListener;
import net.logstash.logback.encoder.CompositeJsonEncoder;
import net.logstash.logback.encoder.SeparatorParser;
import net.logstash.logback.encoder.StreamingEncoder;
import net.logstash.logback.encoder.com.lmax.disruptor.EventHandler;
import net.logstash.logback.encoder.com.lmax.disruptor.LifecycleAware;
import net.logstash.logback.util.ReusableByteBuffer;

public abstract class AbstractLogstashTcpSocketAppender<Event extends DeferredProcessingAware, Listener extends TcpAppenderListener<Event>>
extends AsyncDisruptorAppender<Event, Listener> {
    protected static final String HOST_NAME_FORMAT = "%3$s";
    protected static final String PORT_FORMAT = "%4$d";
    public static final String DEFAULT_THREAD_NAME_FORMAT = "logback-appender-%1$s-%3$s:%4$d-%2$d";
    public static final int DEFAULT_PORT = 4560;
    public static final int DEFAULT_RECONNECTION_DELAY = 30000;
    public static final int DEFAULT_WRITE_TIMEOUT = 0;
    public static final int DEFAULT_INITIALSEND_DELAY = 0;
    @Deprecated
    public static final int DEFAULT_QUEUE_SIZE = 8192;
    public static final int DEFAULT_CONNECTION_TIMEOUT = 5000;
    public static final int DEFAULT_WRITE_BUFFER_SIZE = 8192;
    private static final NotConnectedException NOT_CONNECTED_EXCEPTION = new NotConnectedException();
    private static final ShutdownInProgressException SHUTDOWN_IN_PROGRESS_EXCEPTION = new ShutdownInProgressException();
    private List<InetSocketAddress> destinations = new ArrayList<InetSocketAddress>(2);
    private volatile int connectedDestinationIndex = 0;
    private volatile InetSocketAddress connectedDestination;
    private DestinationConnectionStrategy connectionStrategy = new PreferPrimaryDestinationConnectionStrategy();
    private Duration reconnectionDelay = new Duration(30000L);
    private Duration connectionTimeout = new Duration(5000L);
    private Duration initialSendDelay = new Duration(0L);
    private String peerId;
    private Encoder<Event> encoder;
    private int writeBufferSize = 8192;
    private SocketFactory socketFactory;
    private SSLConfiguration sslConfiguration;
    private Duration keepAliveDuration;
    private String keepAliveMessage = SeparatorParser.parseSeparator("UNIX");
    private Charset keepAliveCharset = StandardCharsets.UTF_8;
    private byte[] keepAliveBytes;
    private Duration writeTimeout = new Duration(0L);
    private volatile CountDownLatch shutdownLatch;
    private ScheduledThreadPoolExecutor executorService;

    public AbstractLogstashTcpSocketAppender() {
        this.setThreadNameFormat(DEFAULT_THREAD_NAME_FORMAT);
    }

    @Override
    protected EventHandler<AsyncDisruptorAppender.LogEvent<Event>> createEventHandler() {
        return new TcpSendingEventHandler();
    }

    public boolean isStarted() {
        CountDownLatch latch = this.shutdownLatch;
        return latch != null && latch.getCount() != 0L;
    }

    @Override
    public synchronized void start() {
        if (this.isStarted()) {
            return;
        }
        int errorCount = 0;
        if (this.encoder == null) {
            ++errorCount;
            this.addError("No encoder was configured. Use <encoder> to specify the fully qualified class name of the encoder to use");
        }
        if (this.destinations.isEmpty()) {
            ++errorCount;
            this.addError("No destination was configured. Use <destination> to add one or more destinations to the appender");
        }
        if (errorCount == 0 && this.socketFactory == null) {
            if (this.sslConfiguration == null) {
                this.socketFactory = SocketFactory.getDefault();
            } else {
                try {
                    SSLContext sslContext = this.getSsl().createContext((ContextAware)this);
                    SSLParametersConfiguration parameters = this.getSsl().getParameters();
                    parameters.setContext(this.getContext());
                    this.socketFactory = new UnconnectedConfigurableSSLSocketFactory(parameters, sslContext.getSocketFactory());
                }
                catch (Exception e) {
                    this.addError("Unable to create ssl context", e);
                    ++errorCount;
                }
            }
        }
        if (this.keepAliveMessage != null) {
            this.keepAliveBytes = this.keepAliveMessage.getBytes(this.keepAliveCharset);
        }
        if (errorCount == 0) {
            this.encoder.setContext(this.getContext());
            if (!this.encoder.isStarted()) {
                this.encoder.start();
            }
            int threadPoolCoreSize = 1;
            if (this.isKeepAliveEnabled()) {
                ++threadPoolCoreSize;
            }
            if (this.isWriteTimeoutEnabled()) {
                ++threadPoolCoreSize;
            }
            this.executorService = new ScheduledThreadPoolExecutor(threadPoolCoreSize, this.getThreadFactory());
            this.executorService.setRemoveOnCancelPolicy(true);
            this.shutdownLatch = new CountDownLatch(1);
            super.start();
        }
    }

    @Override
    public synchronized void stop() {
        if (!this.isStarted()) {
            return;
        }
        super.stop();
        this.shutdownLatch.countDown();
        this.executorService.shutdown();
        try {
            if (!this.executorService.awaitTermination(1L, TimeUnit.MINUTES)) {
                this.addWarn("Some queued events have not been logged due to requested shutdown");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.addWarn("Some queued events have not been logged due to requested shutdown", e);
        }
    }

    protected Future<?> scheduleReaderCallable(Callable<Void> readerCallable) {
        return this.executorService.submit(readerCallable);
    }

    protected void fireEventSent(Socket socket, Event event, long durationInNanos) {
        if (event != null) {
            this.safelyFireEvent(l -> l.eventSent(this, socket, event, durationInNanos));
        }
    }

    protected void fireEventSendFailure(Event event, Throwable reason) {
        if (event != null) {
            this.safelyFireEvent(l -> l.eventSendFailure(this, event, reason));
        }
    }

    protected void fireConnectionOpened(Socket socket) {
        this.safelyFireEvent(l -> l.connectionOpened(this, socket));
    }

    protected void fireConnectionClosed(Socket socket) {
        this.safelyFireEvent(l -> l.connectionClosed(this, socket));
    }

    protected void fireConnectionFailed(InetSocketAddress address, Throwable throwable) {
        this.safelyFireEvent(l -> l.connectionFailed(this, address, throwable));
    }

    public Encoder<Event> getEncoder() {
        return this.encoder;
    }

    public void setEncoder(Encoder<Event> encoder) {
        this.encoder = encoder;
    }

    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public void setSocketFactory(SocketFactory socketFactory) {
        this.socketFactory = socketFactory;
    }

    public void addDestination(String destination) throws IllegalArgumentException {
        List<InetSocketAddress> parsedDestinations = DestinationParser.parse(destination, 4560);
        this.addDestinations(parsedDestinations.toArray(new InetSocketAddress[0]));
    }

    public void addDestinations(InetSocketAddress ... destinations) throws IllegalArgumentException {
        if (destinations == null) {
            return;
        }
        for (InetSocketAddress destination : destinations) {
            try {
                InetAddress.getByName(this.getHostString(destination));
            }
            catch (UnknownHostException ex) {
                this.addWarn("Invalid destination '" + this.getHostString(destination) + "': host unknown (was '" + this.getHostString(destination) + "').");
            }
            this.destinations.add(destination);
        }
    }

    protected String getHostString(InetSocketAddress destination) {
        return destination.getHostString();
    }

    protected void updateCurrentThreadName() {
        Thread.currentThread().setName(this.calculateThreadName());
    }

    @Override
    protected List<Object> getThreadNameFormatParams() {
        List<Object> superThreadNameFormatParams = super.getThreadNameFormatParams();
        ArrayList<Object> threadNameFormatParams = new ArrayList<Object>(superThreadNameFormatParams.size() + 2);
        threadNameFormatParams.addAll(superThreadNameFormatParams);
        InetSocketAddress currentDestination = this.destinations.get(this.connectedDestinationIndex);
        threadNameFormatParams.add(this.getHostString(currentDestination));
        threadNameFormatParams.add(currentDestination.getPort());
        return threadNameFormatParams;
    }

    public List<InetSocketAddress> getDestinations() {
        return Collections.unmodifiableList(this.destinations);
    }

    public void setReconnectionDelay(Duration delay) {
        if (delay == null || delay.getMilliseconds() <= 0L) {
            throw new IllegalArgumentException("reconnectionDelay must be > 0");
        }
        this.reconnectionDelay = delay;
    }

    public Duration getReconnectionDelay() {
        return this.reconnectionDelay;
    }

    public void setInitialSendDelay(Duration delay) {
        if (delay == null || delay.getMilliseconds() < 0L) {
            throw new IllegalArgumentException("initialSendDelay must be >= 0");
        }
        this.initialSendDelay = delay;
    }

    public Duration getInitialSendDelay() {
        return this.initialSendDelay;
    }

    @Deprecated
    public void setSecondaryConnectionTTL(Duration secondaryConnectionTTL) {
        this.addWarn("Setting <secondaryConnectionTTL> directly on the appender is deprecated. Instead you should explicitly set the connection strategy to <preferPrimary> and set its <secondaryConnectionTTL> property to the desired value.");
        if (!(this.connectionStrategy instanceof PreferPrimaryDestinationConnectionStrategy)) {
            throw new IllegalStateException(String.format("When setting the secondaryConnectionTTL, the strategy must be a %s. It is currently a %s", PreferPrimaryDestinationConnectionStrategy.class, this.connectionStrategy));
        }
        ((PreferPrimaryDestinationConnectionStrategy)this.connectionStrategy).setSecondaryConnectionTTL(secondaryConnectionTTL);
    }

    @Deprecated
    public Duration getSecondaryConnectionTTL() {
        if (this.connectionStrategy instanceof PreferPrimaryDestinationConnectionStrategy) {
            return ((PreferPrimaryDestinationConnectionStrategy)this.connectionStrategy).getSecondaryConnectionTTL();
        }
        return null;
    }

    public void setConnectionTimeout(Duration connectionTimeout) {
        if (Objects.requireNonNull(connectionTimeout).getMilliseconds() < 0L) {
            throw new IllegalArgumentException("connectionTimeout must be a positive value");
        }
        this.connectionTimeout = connectionTimeout;
    }

    public Duration getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public int getWriteBufferSize() {
        return this.writeBufferSize;
    }

    public void setWriteBufferSize(int writeBufferSize) {
        this.writeBufferSize = writeBufferSize;
    }

    @Deprecated
    public int getQueueSize() {
        return this.getRingBufferSize();
    }

    @Deprecated
    public void setQueueSize(int queueSize) {
        this.addWarn("<queueSize> is deprecated, use <ringBufferSize> instead");
        this.setRingBufferSize(queueSize);
    }

    public SSLConfiguration getSsl() {
        return this.sslConfiguration;
    }

    public void setSsl(SSLConfiguration sslConfiguration) {
        this.sslConfiguration = sslConfiguration;
    }

    public Duration getKeepAliveDuration() {
        return this.keepAliveDuration;
    }

    public void setKeepAliveDuration(Duration keepAliveDuration) {
        this.keepAliveDuration = keepAliveDuration;
    }

    public String getKeepAliveMessage() {
        return this.keepAliveMessage;
    }

    public void setKeepAliveMessage(String keepAliveMessage) {
        this.keepAliveMessage = SeparatorParser.parseSeparator(keepAliveMessage);
    }

    public boolean isKeepAliveEnabled() {
        return this.keepAliveDuration != null && this.keepAliveDuration.getMilliseconds() > 0L && this.keepAliveMessage != null && !this.keepAliveMessage.isEmpty();
    }

    public boolean isWriteTimeoutEnabled() {
        return this.writeTimeout.getMilliseconds() > 0L;
    }

    public Charset getKeepAliveCharset() {
        return this.keepAliveCharset;
    }

    public void setKeepAliveCharset(Charset keepAliveCharset) {
        this.keepAliveCharset = Objects.requireNonNull(keepAliveCharset);
    }

    @Override
    public void setThreadNameFormat(String threadNameFormat) {
        super.setThreadNameFormat(threadNameFormat);
    }

    public DestinationConnectionStrategy getConnectionStrategy() {
        return this.connectionStrategy;
    }

    @DefaultClass(value=DelegateDestinationConnectionStrategy.class)
    public void setConnectionStrategy(DestinationConnectionStrategy destinationConnectionStrategy) {
        this.connectionStrategy = Objects.requireNonNull(destinationConnectionStrategy);
    }

    public Optional<InetSocketAddress> getConnectedDestination() {
        return Optional.ofNullable(this.connectedDestination);
    }

    public Duration getWriteTimeout() {
        return this.writeTimeout;
    }

    public void setWriteTimeout(Duration writeTimeout) {
        if (writeTimeout == null || writeTimeout.getMilliseconds() < 0L) {
            throw new IllegalArgumentException("writeTimeout must be >= 0");
        }
        this.writeTimeout = writeTimeout;
    }

    static {
        NOT_CONNECTED_EXCEPTION.setStackTrace(new StackTraceElement[]{new StackTraceElement(TcpSendingEventHandler.class.getName(), "onEvent(..)", null, -1)});
        SHUTDOWN_IN_PROGRESS_EXCEPTION.setStackTrace(new StackTraceElement[]{new StackTraceElement(TcpSendingEventHandler.class.getName(), "onEvent(..)", null, -1)});
    }

    private class TcpSendingEventHandler
    implements EventHandler<AsyncDisruptorAppender.LogEvent<Event>>,
    LifecycleAware {
        private static final int MAX_REPEAT_CONNECTION_ERROR_LOG = 5;
        private volatile Socket socket;
        private volatile OutputStream outputStream;
        private volatile long lastSendStartNanoTime;
        private volatile long lastSendEndNanoTime;
        private long[] destinationAttemptStartTimes;
        private ScheduledFuture<?> keepAliveFuture;
        private net.logstash.logback.appender.AbstractLogstashTcpSocketAppender$TcpSendingEventHandler.KeepAliveRunnable keepAliveRunnable;
        private ScheduledFuture<?> writeTimeoutFuture;
        private net.logstash.logback.appender.AbstractLogstashTcpSocketAppender$TcpSendingEventHandler.WriteTimeoutRunnable writeTimeoutRunnable;
        private Future<?> readerFuture;
        private ReusableByteBuffer buffer;

        private TcpSendingEventHandler() {
        }

        @Override
        public void onEvent(AsyncDisruptorAppender.LogEvent<Event> logEvent, long sequence, boolean endOfBatch) throws Exception {
            while (true) {
                Socket socket = this.socket;
                OutputStream outputStream = this.outputStream;
                if (socket == null && (!AbstractLogstashTcpSocketAppender.this.isStarted() || Thread.currentThread().isInterrupted())) {
                    AbstractLogstashTcpSocketAppender.this.fireEventSendFailure((DeferredProcessingAware)logEvent.event, SHUTDOWN_IN_PROGRESS_EXCEPTION);
                    break;
                }
                if (socket == null) {
                    this.reopenSocket();
                    continue;
                }
                Future<?> readerFuture = this.readerFuture;
                if (readerFuture.isDone()) {
                    String msg = "destination terminated the connection";
                    try {
                        readerFuture.get();
                    }
                    catch (ExecutionException e) {
                        msg = msg + " (cause: " + e.getCause().getMessage() + ")";
                    }
                    AbstractLogstashTcpSocketAppender.this.addInfo(AbstractLogstashTcpSocketAppender.this.peerId + msg + ". Reconnecting.");
                    this.reopenSocket();
                    continue;
                }
                try {
                    this.writeEvent(socket, outputStream, logEvent, endOfBatch);
                    return;
                }
                catch (EncoderException e) {
                    AbstractLogstashTcpSocketAppender.this.addWarn(AbstractLogstashTcpSocketAppender.this.peerId + "Encoder failed to encode event. Dropping event.", e.getCause());
                    AbstractLogstashTcpSocketAppender.this.fireEventSendFailure((DeferredProcessingAware)logEvent.event, e.getCause());
                }
                catch (Exception e) {
                    AbstractLogstashTcpSocketAppender.this.addWarn(AbstractLogstashTcpSocketAppender.this.peerId + "Unable to send event. Reconnecting.", e);
                    this.reopenSocket();
                    continue;
                }
                break;
            }
        }

        private void writeEvent(Socket socket, OutputStream outputStream, AsyncDisruptorAppender.LogEvent<Event> logEvent, boolean endOfBatch) throws IOException, EncoderException {
            long endNanoTime;
            long startNanoTime;
            long startWallTime = System.currentTimeMillis();
            this.lastSendStartNanoTime = startNanoTime = System.nanoTime();
            if (logEvent.event != null) {
                this.encode((DeferredProcessingAware)logEvent.event, outputStream);
            } else if (this.hasKeepAliveDurationElapsed(this.lastSendEndNanoTime, startNanoTime)) {
                outputStream.write(AbstractLogstashTcpSocketAppender.this.keepAliveBytes);
            }
            if (endOfBatch) {
                outputStream.flush();
            }
            this.lastSendEndNanoTime = endNanoTime = System.nanoTime();
            if (logEvent.event != null) {
                AbstractLogstashTcpSocketAppender.this.fireEventSent(socket, (DeferredProcessingAware)logEvent.event, endNanoTime - startNanoTime);
            }
            if (AbstractLogstashTcpSocketAppender.this.connectionStrategy.shouldReconnect(startWallTime, AbstractLogstashTcpSocketAppender.this.connectedDestinationIndex, AbstractLogstashTcpSocketAppender.this.destinations.size())) {
                AbstractLogstashTcpSocketAppender.this.addInfo(AbstractLogstashTcpSocketAppender.this.peerId + "reestablishing connection.");
                outputStream.flush();
                this.reopenSocket();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void encode(Event event, OutputStream outputStream) throws IOException, EncoderException {
            byte[] data;
            if (AbstractLogstashTcpSocketAppender.this.encoder instanceof StreamingEncoder) {
                try {
                    try {
                        ((StreamingEncoder)AbstractLogstashTcpSocketAppender.this.encoder).encode(event, this.buffer);
                    }
                    catch (Exception e) {
                        throw new EncoderException(e);
                    }
                    this.buffer.writeTo(outputStream);
                }
                finally {
                    this.buffer.reset();
                }
            }
            try {
                data = AbstractLogstashTcpSocketAppender.this.encoder.encode(event);
            }
            catch (Exception e) {
                throw new EncoderException(e);
            }
            if (data != null) {
                outputStream.write(data);
            }
        }

        private boolean hasKeepAliveDurationElapsed(long lastSentNanoTime, long currentNanoTime) {
            return AbstractLogstashTcpSocketAppender.this.isKeepAliveEnabled() && lastSentNanoTime + TimeUnit.MILLISECONDS.toNanos(AbstractLogstashTcpSocketAppender.this.keepAliveDuration.getMilliseconds()) < currentNanoTime;
        }

        @Override
        public void onStart() {
            this.destinationAttemptStartTimes = new long[AbstractLogstashTcpSocketAppender.this.destinations.size()];
            if (AbstractLogstashTcpSocketAppender.this.encoder instanceof CompositeJsonEncoder) {
                this.buffer = new ReusableByteBuffer(((CompositeJsonEncoder)AbstractLogstashTcpSocketAppender.this.encoder).getMinBufferSize());
            } else if (AbstractLogstashTcpSocketAppender.this.encoder instanceof StreamingEncoder) {
                this.buffer = new ReusableByteBuffer();
            }
            this.openSocket();
            this.scheduleKeepAlive(System.nanoTime());
            this.scheduleWriteTimeout();
        }

        @Override
        public void onShutdown() {
            this.unscheduleWriteTimeout();
            this.unscheduleKeepAlive();
            this.closeEncoder();
            this.closeSocket();
        }

        private synchronized void reopenSocket() {
            this.closeSocket();
            this.openSocket();
        }

        private synchronized void openSocket() {
            int errorCount = 0;
            int destinationIndex = AbstractLogstashTcpSocketAppender.this.connectedDestinationIndex;
            while (AbstractLogstashTcpSocketAppender.this.isStarted() && !Thread.currentThread().isInterrupted()) {
                destinationIndex = AbstractLogstashTcpSocketAppender.this.connectionStrategy.selectNextDestinationIndex(destinationIndex, AbstractLogstashTcpSocketAppender.this.destinations.size());
                long startWallTime = System.currentTimeMillis();
                Socket tempSocket = null;
                OutputStream tempOutputStream = null;
                InetSocketAddress currentDestination = (InetSocketAddress)AbstractLogstashTcpSocketAppender.this.destinations.get(destinationIndex);
                try {
                    AbstractLogstashTcpSocketAppender.this.peerId = "Log destination " + currentDestination + ": ";
                    long millisSinceLastAttempt = startWallTime - this.destinationAttemptStartTimes[destinationIndex];
                    if (millisSinceLastAttempt < AbstractLogstashTcpSocketAppender.this.reconnectionDelay.getMilliseconds()) {
                        long sleepTime = AbstractLogstashTcpSocketAppender.this.reconnectionDelay.getMilliseconds() - millisSinceLastAttempt;
                        if (errorCount < 5 * AbstractLogstashTcpSocketAppender.this.destinations.size()) {
                            AbstractLogstashTcpSocketAppender.this.addWarn(AbstractLogstashTcpSocketAppender.this.peerId + "Waiting " + sleepTime + "ms before attempting reconnection.");
                        }
                        this.sleepUnlessStopped(sleepTime);
                        startWallTime = System.currentTimeMillis();
                    }
                    this.destinationAttemptStartTimes[destinationIndex] = startWallTime;
                    tempSocket = AbstractLogstashTcpSocketAppender.this.socketFactory.createSocket();
                    tempSocket.setSoTimeout((int)AbstractLogstashTcpSocketAppender.this.connectionTimeout.getMilliseconds());
                    tempSocket.connect(new InetSocketAddress(AbstractLogstashTcpSocketAppender.this.getHostString(currentDestination), currentDestination.getPort()), (int)AbstractLogstashTcpSocketAppender.this.connectionTimeout.getMilliseconds());
                    if (tempSocket instanceof SSLSocket) {
                        ((SSLSocket)tempSocket).startHandshake();
                    }
                    tempOutputStream = AbstractLogstashTcpSocketAppender.this.writeBufferSize > 0 ? new BufferedOutputStream(tempSocket.getOutputStream(), AbstractLogstashTcpSocketAppender.this.writeBufferSize) : tempSocket.getOutputStream();
                    AbstractLogstashTcpSocketAppender.this.addInfo(AbstractLogstashTcpSocketAppender.this.peerId + "connection established.");
                    this.socket = tempSocket;
                    this.outputStream = tempOutputStream;
                    boolean shouldUpdateThreadName = destinationIndex != AbstractLogstashTcpSocketAppender.this.connectedDestinationIndex;
                    AbstractLogstashTcpSocketAppender.this.connectedDestinationIndex = destinationIndex;
                    AbstractLogstashTcpSocketAppender.this.connectedDestination = currentDestination;
                    AbstractLogstashTcpSocketAppender.this.connectionStrategy.connectSuccess(startWallTime, destinationIndex, AbstractLogstashTcpSocketAppender.this.destinations.size());
                    if (shouldUpdateThreadName) {
                        AbstractLogstashTcpSocketAppender.this.updateCurrentThreadName();
                    }
                    this.readerFuture = AbstractLogstashTcpSocketAppender.this.scheduleReaderCallable(new ReaderCallable(tempSocket.getInputStream()));
                    AbstractLogstashTcpSocketAppender.this.fireConnectionOpened(this.socket);
                    this.sleepUnlessStopped(AbstractLogstashTcpSocketAppender.this.initialSendDelay.getMilliseconds());
                    return;
                }
                catch (InterruptedException ie) {
                    CloseUtil.closeQuietly(tempOutputStream);
                    CloseUtil.closeQuietly(tempSocket);
                    Thread.currentThread().interrupt();
                }
                catch (Exception e) {
                    CloseUtil.closeQuietly(tempOutputStream);
                    CloseUtil.closeQuietly(tempSocket);
                    AbstractLogstashTcpSocketAppender.this.connectionStrategy.connectFailed(startWallTime, destinationIndex, AbstractLogstashTcpSocketAppender.this.destinations.size());
                    AbstractLogstashTcpSocketAppender.this.fireConnectionFailed(currentDestination, e);
                    if (errorCount++ >= 5 * AbstractLogstashTcpSocketAppender.this.destinations.size()) continue;
                    AbstractLogstashTcpSocketAppender.this.addWarn(AbstractLogstashTcpSocketAppender.this.peerId + "connection failed.", e);
                }
            }
        }

        private void sleepUnlessStopped(long millis) throws InterruptedException {
            if (AbstractLogstashTcpSocketAppender.this.shutdownLatch.await(millis, TimeUnit.MILLISECONDS) || !AbstractLogstashTcpSocketAppender.this.isStarted()) {
                throw new InterruptedException();
            }
        }

        private synchronized void closeSocket() {
            AbstractLogstashTcpSocketAppender.this.connectedDestination = null;
            CloseUtil.closeQuietly((Closeable)this.outputStream);
            this.outputStream = null;
            CloseUtil.closeQuietly((Socket)this.socket);
            AbstractLogstashTcpSocketAppender.this.fireConnectionClosed(this.socket);
            this.socket = null;
            if (this.readerFuture != null) {
                this.readerFuture.cancel(true);
            }
        }

        private void closeEncoder() {
            AbstractLogstashTcpSocketAppender.this.encoder.stop();
            this.buffer = null;
        }

        private synchronized void scheduleKeepAlive(long basedOnNanoTime) {
            if (AbstractLogstashTcpSocketAppender.this.isKeepAliveEnabled() && !Thread.currentThread().isInterrupted()) {
                if (this.keepAliveRunnable == null) {
                    this.keepAliveRunnable = new KeepAliveRunnable();
                }
                long delay = TimeUnit.MILLISECONDS.toNanos(AbstractLogstashTcpSocketAppender.this.keepAliveDuration.getMilliseconds()) - (System.nanoTime() - basedOnNanoTime);
                try {
                    this.keepAliveFuture = AbstractLogstashTcpSocketAppender.this.executorService.schedule((Runnable)this.keepAliveRunnable, delay, TimeUnit.NANOSECONDS);
                }
                catch (RejectedExecutionException e) {
                    this.keepAliveFuture = null;
                }
            }
        }

        private synchronized void unscheduleKeepAlive() {
            if (this.keepAliveFuture != null) {
                this.keepAliveFuture.cancel(true);
                try {
                    this.keepAliveFuture.get();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        private synchronized void scheduleWriteTimeout() {
            if (AbstractLogstashTcpSocketAppender.this.isWriteTimeoutEnabled() && !Thread.currentThread().isInterrupted()) {
                if (this.writeTimeoutRunnable == null) {
                    this.writeTimeoutRunnable = new WriteTimeoutRunnable();
                }
                long delay = AbstractLogstashTcpSocketAppender.this.writeTimeout.getMilliseconds();
                try {
                    this.writeTimeoutFuture = AbstractLogstashTcpSocketAppender.this.executorService.scheduleWithFixedDelay((Runnable)this.writeTimeoutRunnable, delay, delay, TimeUnit.MILLISECONDS);
                }
                catch (RejectedExecutionException e) {
                    this.writeTimeoutFuture = null;
                }
            }
        }

        private synchronized void unscheduleWriteTimeout() {
            if (this.writeTimeoutFuture != null) {
                this.writeTimeoutFuture.cancel(true);
                try {
                    this.writeTimeoutFuture.get();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        private class ReaderCallable
        implements Callable<Void> {
            private final InputStream inputStream;

            ReaderCallable(InputStream inputStream) {
                this.inputStream = inputStream;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Void call() throws Exception {
                AbstractLogstashTcpSocketAppender.this.updateCurrentThreadName();
                while (true) {
                    try {
                        while (this.inputStream.read() != -1) {
                        }
                        Void void_ = null;
                        if (Thread.currentThread().isInterrupted()) return void_;
                        AbstractLogstashTcpSocketAppender.this.executorService.submit(() -> AbstractLogstashTcpSocketAppender.this.getDisruptor().getRingBuffer().tryPublishEvent(AbstractLogstashTcpSocketAppender.this.getEventTranslator(), null));
                        return void_;
                    }
                    catch (SocketTimeoutException socketTimeoutException) {
                        continue;
                    }
                    catch (Exception e) {
                        throw e;
                    }
                    catch (Throwable throwable) {
                        if (Thread.currentThread().isInterrupted()) throw throwable;
                        AbstractLogstashTcpSocketAppender.this.executorService.submit(() -> AbstractLogstashTcpSocketAppender.this.getDisruptor().getRingBuffer().tryPublishEvent(AbstractLogstashTcpSocketAppender.this.getEventTranslator(), null));
                        throw throwable;
                    }
                    break;
                }
            }
        }

        private class KeepAliveRunnable
        implements Runnable {
            private int previousDestinationIndex;

            private KeepAliveRunnable() {
                this.previousDestinationIndex = AbstractLogstashTcpSocketAppender.this.connectedDestinationIndex;
            }

            @Override
            public void run() {
                long currentNanoTime;
                long lastSendEnd = TcpSendingEventHandler.this.lastSendEndNanoTime;
                if (TcpSendingEventHandler.this.hasKeepAliveDurationElapsed(lastSendEnd, currentNanoTime = System.nanoTime())) {
                    AbstractLogstashTcpSocketAppender.this.getDisruptor().getRingBuffer().tryPublishEvent(AbstractLogstashTcpSocketAppender.this.getEventTranslator(), null);
                    TcpSendingEventHandler.this.scheduleKeepAlive(currentNanoTime);
                } else {
                    TcpSendingEventHandler.this.scheduleKeepAlive(lastSendEnd);
                }
                if (this.previousDestinationIndex != AbstractLogstashTcpSocketAppender.this.connectedDestinationIndex) {
                    AbstractLogstashTcpSocketAppender.this.updateCurrentThreadName();
                }
                this.previousDestinationIndex = AbstractLogstashTcpSocketAppender.this.connectedDestinationIndex;
            }
        }

        private class WriteTimeoutRunnable
        implements Runnable {
            private volatile long lastDetectedStartNanoTime;

            private WriteTimeoutRunnable() {
            }

            @Override
            public void run() {
                long elapsedSendTimeInMillis;
                long lastSendEnd;
                long lastSendStart = TcpSendingEventHandler.this.lastSendStartNanoTime;
                if (lastSendStart > (lastSendEnd = TcpSendingEventHandler.this.lastSendEndNanoTime) && lastSendStart != this.lastDetectedStartNanoTime && (elapsedSendTimeInMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - lastSendStart)) > AbstractLogstashTcpSocketAppender.this.writeTimeout.getMilliseconds()) {
                    this.lastDetectedStartNanoTime = lastSendStart;
                    AbstractLogstashTcpSocketAppender.this.addWarn(AbstractLogstashTcpSocketAppender.this.peerId + "Detected write timeout after " + elapsedSendTimeInMillis + "ms (writeTimeout=" + AbstractLogstashTcpSocketAppender.this.getWriteTimeout() + "). Closing socket to force reconnect.");
                    TcpSendingEventHandler.this.closeSocket();
                }
            }
        }
    }

    private static class UnconnectedConfigurableSSLSocketFactory
    extends ConfigurableSSLSocketFactory {
        private final SSLParametersConfiguration parameters;
        private final SSLSocketFactory delegate;

        UnconnectedConfigurableSSLSocketFactory(SSLParametersConfiguration parameters, SSLSocketFactory delegate) {
            super(parameters, delegate);
            this.parameters = parameters;
            this.delegate = delegate;
        }

        public Socket createSocket() throws IOException {
            SSLSocket socket = (SSLSocket)this.delegate.createSocket();
            this.parameters.configure((SSLConfigurable)new SSLConfigurableSocket(socket));
            return socket;
        }
    }

    private static class EncoderException
    extends Exception {
        EncoderException(Throwable cause) {
            super(cause);
        }
    }
}

