/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.appender;

import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.net.ssl.ConfigurableSSLSocketFactory;
import ch.qos.logback.core.net.ssl.SSLConfigurable;
import ch.qos.logback.core.net.ssl.SSLConfigurableSocket;
import ch.qos.logback.core.net.ssl.SSLConfiguration;
import ch.qos.logback.core.net.ssl.SSLParametersConfiguration;
import ch.qos.logback.core.spi.ContextAware;
import ch.qos.logback.core.spi.DeferredProcessingAware;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.util.CloseUtil;
import ch.qos.logback.core.util.Duration;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import net.logstash.logback.appender.AbstractLogstashTcpSocketAppender;
import net.logstash.logback.appender.AsyncDisruptorAppender;
import net.logstash.logback.encoder.SeparatorParser;
import net.logstash.logback.encoder.com.lmax.disruptor.EventHandler;
import net.logstash.logback.encoder.com.lmax.disruptor.LifecycleAware;

public abstract class AbstractLogstashTcpSocketAppender<Event extends DeferredProcessingAware>
extends AsyncDisruptorAppender<Event> {
    public static final int DEFAULT_PORT = 4560;
    public static final int DEFAULT_RECONNECTION_DELAY = 30000;
    public static final int DEFAULT_QUEUE_SIZE = 8192;
    public static final int DEFAULT_CONNECTION_TIMEOUT = 5000;
    public static final int DEFAULT_WRITE_BUFFER_SIZE = 8192;
    private String remoteHost;
    private int port = 4560;
    private Duration reconnectionDelay = new Duration(30000L);
    private int acceptConnectionTimeout = 5000;
    private String peerId;
    private Encoder<Event> encoder;
    private int writeBufferSize = 8192;
    private SocketFactory socketFactory;
    private SSLConfiguration sslConfiguration;
    private Duration keepAliveDuration;
    private String keepAliveMessage = System.lineSeparator();
    private Charset keepAliveCharset = Charset.forName("UTF-8");
    private byte[] keepAliveBytes;

    public AbstractLogstashTcpSocketAppender() {
        this.setEventHandler(new TcpSendingEventHandler());
    }

    @Override
    public void start() {
        if (this.isStarted()) {
            return;
        }
        int errorCount = 0;
        if (this.encoder == null) {
            ++errorCount;
            this.addError("No encoder was configured for appender " + this.name + ".");
        }
        if (this.port <= 0) {
            ++errorCount;
            this.addError("No port was configured for appender " + this.name + ".");
        }
        if (this.remoteHost == null) {
            ++errorCount;
            this.addError("No remote host was configured for appender " + this.name + ".");
        }
        if (errorCount == 0) {
            try {
                InetAddress.getByName(this.remoteHost);
            }
            catch (UnknownHostException ex) {
                this.addError("unknown host: " + this.remoteHost);
                ++errorCount;
            }
        }
        if (errorCount == 0 && this.socketFactory == null) {
            if (this.sslConfiguration == null) {
                this.socketFactory = SocketFactory.getDefault();
            } else {
                try {
                    SSLContext sslContext = this.getSsl().createContext((ContextAware)this);
                    SSLParametersConfiguration parameters = this.getSsl().getParameters();
                    parameters.setContext(this.getContext());
                    this.socketFactory = new UnconnectedConfigurableSSLSocketFactory(parameters, sslContext.getSocketFactory());
                }
                catch (Exception e) {
                    this.addError("Unable to create ssl context", e);
                    ++errorCount;
                }
            }
        }
        if (this.keepAliveMessage != null && this.keepAliveCharset != null) {
            this.keepAliveBytes = this.keepAliveMessage.getBytes(this.keepAliveCharset);
        }
        if (errorCount == 0) {
            if (this.getThreadNamePrefix() == "logback-async-disruptor-appender-") {
                this.setThreadNamePrefix("logback-async-disruptor-appender-" + this.remoteHost + ":" + this.port + "-");
            }
            this.encoder.setContext(this.getContext());
            if (!this.encoder.isStarted()) {
                this.encoder.start();
            }
            this.peerId = "Log destination " + this.remoteHost + ":" + this.port + ": ";
            if (this.keepAliveDuration != null) {
                this.setThreadPoolCoreSize(this.getThreadPoolCoreSize() + 1);
            }
            super.start();
        }
    }

    public Encoder<Event> getEncoder() {
        return this.encoder;
    }

    public void setEncoder(Encoder<Event> encoder) {
        this.encoder = encoder;
    }

    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public void setSocketFactory(SocketFactory socketFactory) {
        this.socketFactory = socketFactory;
    }

    public void setRemoteHost(String host) {
        this.remoteHost = host;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setReconnectionDelay(Duration delay) {
        if (delay == null || delay.getMilliseconds() <= 0L) {
            throw new IllegalArgumentException("reconnectionDelay must be > 0");
        }
        this.reconnectionDelay = delay;
    }

    public Duration getReconnectionDelay() {
        return this.reconnectionDelay;
    }

    void setAcceptConnectionTimeout(int acceptConnectionTimeout) {
        this.acceptConnectionTimeout = acceptConnectionTimeout;
    }

    public int getWriteBufferSize() {
        return this.writeBufferSize;
    }

    public void setWriteBufferSize(int writeBufferSize) {
        this.writeBufferSize = writeBufferSize;
    }

    public int getQueueSize() {
        return this.getRingBufferSize();
    }

    public void setQueueSize(int queueSize) {
        this.setRingBufferSize(queueSize);
    }

    public SSLConfiguration getSsl() {
        return this.sslConfiguration;
    }

    public void setSsl(SSLConfiguration sslConfiguration) {
        this.sslConfiguration = sslConfiguration;
    }

    public Duration getKeepAliveDuration() {
        return this.keepAliveDuration;
    }

    public void setKeepAliveDuration(Duration keepAliveDuration) {
        this.keepAliveDuration = keepAliveDuration;
    }

    public String getKeepAliveMessage() {
        return this.keepAliveMessage;
    }

    public void setKeepAliveMessage(String keepAliveMessage) {
        this.keepAliveMessage = SeparatorParser.parseSeparator(keepAliveMessage);
    }

    public boolean isKeepAliveEnabled() {
        return this.keepAliveDuration != null && this.keepAliveMessage != null;
    }

    public Charset getKeepAliveCharset() {
        return this.keepAliveCharset;
    }

    public void setKeepAliveCharset(String keepAliveCharset) {
        this.keepAliveCharset = Charset.forName(keepAliveCharset);
    }

    private static class UnconnectedConfigurableSSLSocketFactory
    extends ConfigurableSSLSocketFactory {
        private final SSLParametersConfiguration parameters;
        private final SSLSocketFactory delegate;

        public UnconnectedConfigurableSSLSocketFactory(SSLParametersConfiguration parameters, SSLSocketFactory delegate) {
            super(parameters, delegate);
            this.parameters = parameters;
            this.delegate = delegate;
        }

        public Socket createSocket() throws IOException {
            SSLSocket socket = (SSLSocket)this.delegate.createSocket();
            this.parameters.configure((SSLConfigurable)new SSLConfigurableSocket(socket));
            return socket;
        }
    }

    private class TcpSendingEventHandler
    implements EventHandler<AsyncDisruptorAppender.LogEvent<Event>>,
    LifecycleAware {
        private static final int MAX_REPEAT_CONNECTION_ERROR_LOG = 5;
        private static final int MAX_REPEAT_WRITE_ATTEMPTS = 5;
        private volatile boolean started;
        private volatile Socket socket;
        private volatile OutputStream outputStream;
        private volatile long lastSentTimestamp;
        private ScheduledFuture<?> keepAliveFuture;
        private net.logstash.logback.appender.AbstractLogstashTcpSocketAppender$TcpSendingEventHandler.KeepAliveRunnable keepAliveRunnable;

        private TcpSendingEventHandler() {
        }

        @Override
        public void onEvent(AsyncDisruptorAppender.LogEvent<Event> logEvent, long sequence, boolean endOfBatch) throws Exception {
            for (int i = 0; i < 5; ++i) {
                if (!this.started) {
                    return;
                }
                try {
                    long currentTime = System.currentTimeMillis();
                    if (logEvent.event != null) {
                        AbstractLogstashTcpSocketAppender.this.encoder.doEncode(logEvent.event);
                    } else if (this.hasKeepAliveDurationElapsed(this.lastSentTimestamp, currentTime)) {
                        this.outputStream.write(AbstractLogstashTcpSocketAppender.this.keepAliveBytes);
                    }
                    if (endOfBatch) {
                        this.outputStream.flush();
                    }
                    this.lastSentTimestamp = currentTime;
                    break;
                }
                catch (Exception e) {
                    AbstractLogstashTcpSocketAppender.this.addWarn(AbstractLogstashTcpSocketAppender.this.peerId + "unable to send event: " + e.getMessage(), e);
                    this.reopenSocket();
                    continue;
                }
            }
        }

        private boolean hasKeepAliveDurationElapsed(long lastSent, long currentTime) {
            return AbstractLogstashTcpSocketAppender.this.isKeepAliveEnabled() && lastSent + AbstractLogstashTcpSocketAppender.this.keepAliveDuration.getMilliseconds() < currentTime;
        }

        @Override
        public void onStart() {
            this.started = true;
            this.openSocket();
            this.scheduleKeepAlive(System.currentTimeMillis());
        }

        @Override
        public void onShutdown() {
            this.started = false;
            this.unscheduleKeepAlive();
            this.closeEncoder();
            this.closeSocket();
        }

        private synchronized void reopenSocket() {
            this.closeSocket();
            this.openSocket();
        }

        private synchronized void openSocket() {
            int errorCount = 0;
            while (this.started && !Thread.currentThread().isInterrupted()) {
                long startTime = System.currentTimeMillis();
                Socket tempSocket = null;
                BufferedOutputStream tempOutputStream = null;
                try {
                    tempSocket = AbstractLogstashTcpSocketAppender.this.socketFactory.createSocket();
                    tempSocket.connect(new InetSocketAddress(AbstractLogstashTcpSocketAppender.this.remoteHost, AbstractLogstashTcpSocketAppender.this.port), AbstractLogstashTcpSocketAppender.this.acceptConnectionTimeout);
                    tempOutputStream = new BufferedOutputStream(tempSocket.getOutputStream(), AbstractLogstashTcpSocketAppender.this.writeBufferSize);
                    AbstractLogstashTcpSocketAppender.this.encoder.init((OutputStream)tempOutputStream);
                    AbstractLogstashTcpSocketAppender.this.addInfo(AbstractLogstashTcpSocketAppender.this.peerId + "connection established.");
                    this.socket = tempSocket;
                    this.outputStream = tempOutputStream;
                    return;
                }
                catch (Exception e) {
                    CloseUtil.closeQuietly(tempOutputStream);
                    CloseUtil.closeQuietly((Socket)tempSocket);
                    long sleepTime = AbstractLogstashTcpSocketAppender.this.reconnectionDelay.getMilliseconds() - (System.currentTimeMillis() - startTime);
                    if (errorCount++ < 5) {
                        AbstractLogstashTcpSocketAppender.this.addWarn(AbstractLogstashTcpSocketAppender.this.peerId + "connection failed. Waiting " + sleepTime + "ms before attempting reconnection.", e);
                    }
                    if (sleepTime <= 0L) continue;
                    try {
                        Thread.sleep(sleepTime);
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        AbstractLogstashTcpSocketAppender.this.addWarn(AbstractLogstashTcpSocketAppender.this.peerId + "connection interrupted. Will no longer attempt reconnection");
                        return;
                    }
                }
            }
        }

        private synchronized void closeSocket() {
            CloseUtil.closeQuietly((Closeable)this.outputStream);
            this.outputStream = null;
            CloseUtil.closeQuietly((Socket)this.socket);
            this.socket = null;
        }

        private void closeEncoder() {
            try {
                AbstractLogstashTcpSocketAppender.this.encoder.close();
            }
            catch (IOException ioe) {
                AbstractLogstashTcpSocketAppender.this.addStatus((Status)new ErrorStatus("Failed to close encoder for appender named [" + AbstractLogstashTcpSocketAppender.this.name + "].", (Object)this, (Throwable)ioe));
            }
            AbstractLogstashTcpSocketAppender.this.encoder.stop();
        }

        private synchronized void scheduleKeepAlive(long basedOnTime) {
            if (AbstractLogstashTcpSocketAppender.this.isKeepAliveEnabled() && !Thread.currentThread().isInterrupted()) {
                if (this.keepAliveRunnable == null) {
                    this.keepAliveRunnable = new KeepAliveRunnable();
                }
                long delay = AbstractLogstashTcpSocketAppender.this.keepAliveDuration.getMilliseconds() - (System.currentTimeMillis() - basedOnTime);
                this.keepAliveFuture = AbstractLogstashTcpSocketAppender.this.getExecutorService().schedule((Runnable)this.keepAliveRunnable, delay, TimeUnit.MILLISECONDS);
            }
        }

        private synchronized void unscheduleKeepAlive() {
            if (this.keepAliveFuture != null) {
                this.keepAliveFuture.cancel(true);
                try {
                    this.keepAliveFuture.get();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        private class KeepAliveRunnable
        implements Runnable {
            private KeepAliveRunnable() {
            }

            @Override
            public void run() {
                long currentTime;
                long lastSent = TcpSendingEventHandler.this.lastSentTimestamp;
                if (TcpSendingEventHandler.this.hasKeepAliveDurationElapsed(lastSent, currentTime = System.currentTimeMillis())) {
                    AbstractLogstashTcpSocketAppender.this.getDisruptor().getRingBuffer().publishEvent(AbstractLogstashTcpSocketAppender.this.getEventTranslator(), null);
                    TcpSendingEventHandler.this.scheduleKeepAlive(currentTime);
                } else {
                    TcpSendingEventHandler.this.scheduleKeepAlive(lastSent);
                }
            }
        }
    }
}

