/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.encoder;

import ch.qos.logback.classic.pattern.ThrowableHandlingConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.encoder.EncoderBase;
import ch.qos.logback.core.spi.ContextAware;
import java.io.IOException;
import java.util.List;
import net.logstash.logback.LogstashFormatter;
import net.logstash.logback.decorate.JsonFactoryDecorator;
import net.logstash.logback.decorate.JsonGeneratorDecorator;
import net.logstash.logback.encoder.org.apache.commons.io.IOUtils;
import net.logstash.logback.fieldnames.LogstashFieldNames;

public class LogstashEncoder
extends EncoderBase<ILoggingEvent> {
    private boolean immediateFlush = true;
    private final LogstashFormatter formatter = new LogstashFormatter((ContextAware)this);

    public void doEncode(ILoggingEvent event) throws IOException {
        this.formatter.writeValueToOutputStream(event, this.context, this.outputStream);
        IOUtils.write(CoreConstants.LINE_SEPARATOR, this.outputStream);
        if (this.immediateFlush) {
            this.outputStream.flush();
        }
    }

    public void start() {
        super.start();
        this.formatter.start();
    }

    public void stop() {
        super.stop();
        this.formatter.stop();
    }

    public void close() throws IOException {
        IOUtils.write(CoreConstants.LINE_SEPARATOR, this.outputStream);
    }

    public boolean isImmediateFlush() {
        return this.immediateFlush;
    }

    public void setImmediateFlush(boolean immediateFlush) {
        this.immediateFlush = immediateFlush;
    }

    public boolean isIncludeCallerInfo() {
        return this.formatter.isIncludeCallerInfo();
    }

    public void setIncludeCallerInfo(boolean includeCallerInfo) {
        this.formatter.setIncludeCallerInfo(includeCallerInfo);
    }

    public void setCustomFields(String customFields) {
        this.formatter.setCustomFieldsFromString(customFields);
    }

    public String getCustomFields() {
        return this.formatter.getCustomFields().toString();
    }

    public LogstashFieldNames getFieldNames() {
        return (LogstashFieldNames)this.formatter.getFieldNames();
    }

    public void setFieldNames(LogstashFieldNames fieldNames) {
        this.formatter.setFieldNames(fieldNames);
    }

    public int getShortenedLoggerNameLength() {
        return this.formatter.getShortenedLoggerNameLength();
    }

    public void setShortenedLoggerNameLength(int length) {
        this.formatter.setShortenedLoggerNameLength(length);
    }

    public boolean isIncludeMdc() {
        return this.formatter.isIncludeMdc();
    }

    public void setIncludeMdc(boolean includeMdc) {
        this.formatter.setIncludeMdc(includeMdc);
    }

    public List<String> getIncludeMdcKeyNames() {
        return this.formatter.getIncludeMdcKeyNames();
    }

    public void addIncludeMdcKeyName(String includedMdcKeyName) {
        this.formatter.addIncludeMdcKeyName(includedMdcKeyName);
    }

    public void setIncludeMdcKeyNames(List<String> includeMdcKeyNames) {
        this.formatter.setIncludeMdcKeyNames(includeMdcKeyNames);
    }

    public List<String> getExcludeMdcKeyNames() {
        return this.formatter.getExcludeMdcKeyNames();
    }

    public void addExcludeMdcKeyName(String excludedMdcKeyName) {
        this.formatter.addExcludeMdcKeyName(excludedMdcKeyName);
    }

    public void setExcludeMdcKeyNames(List<String> excludeMdcKeyNames) {
        this.formatter.setExcludeMdcKeyNames(excludeMdcKeyNames);
    }

    public boolean isIncludeContext() {
        return this.formatter.isIncludeContext();
    }

    public void setIncludeContext(boolean includeContext) {
        this.formatter.setIncludeContext(includeContext);
    }

    @Deprecated
    public void setEnableContextMap(boolean enableContextMap) {
        this.formatter.setEnableContextMap(enableContextMap);
    }

    @Deprecated
    public boolean isEnableContextMap() {
        return this.formatter.isEnableContextMap();
    }

    public JsonFactoryDecorator getJsonFactoryDecorator() {
        return this.formatter.getJsonFactoryDecorator();
    }

    public void setJsonFactoryDecorator(JsonFactoryDecorator jsonFactoryDecorator) {
        this.formatter.setJsonFactoryDecorator(jsonFactoryDecorator);
    }

    public JsonGeneratorDecorator getJsonGeneratorDecorator() {
        return this.formatter.getJsonGeneratorDecorator();
    }

    public void setJsonGeneratorDecorator(JsonGeneratorDecorator jsonGeneratorDecorator) {
        this.formatter.setJsonGeneratorDecorator(jsonGeneratorDecorator);
    }

    public ThrowableHandlingConverter getThrowableConverter() {
        return this.formatter.getThrowableConverter();
    }

    public void setThrowableConverter(ThrowableHandlingConverter throwableConverter) {
        this.formatter.setThrowableConverter(throwableConverter);
    }

    public String getTimeZone() {
        return this.formatter.getTimeZone();
    }

    public void setTimeZone(String timeZoneId) {
        this.formatter.setTimeZone(timeZoneId);
    }

    protected LogstashFormatter getFormatter() {
        return this.formatter;
    }
}

