/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.layout;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.LayoutBase;
import ch.qos.logback.core.spi.ContextAware;
import java.io.IOException;
import net.logstash.logback.LogstashFormatter;
import net.logstash.logback.fieldnames.LogstashFieldNames;

public class LogstashLayout
extends LayoutBase<ILoggingEvent> {
    private final LogstashFormatter formatter = new LogstashFormatter();

    public String doLayout(ILoggingEvent event) {
        try {
            return this.formatter.writeValueAsString(event, this.getContext());
        }
        catch (IOException e) {
            this.addWarn("Error formatting logging event", e);
            return null;
        }
    }

    public void setCustomFields(String customFields) {
        this.formatter.setCustomFieldsFromString(customFields, (ContextAware)this);
    }

    public String getCustomFields() {
        return this.formatter.getCustomFields().toString();
    }

    public boolean isIncludeCallerInfo() {
        return this.formatter.isIncludeCallerInfo();
    }

    public void setIncludeCallerInfo(boolean includeCallerInfo) {
        this.formatter.setIncludeCallerInfo(includeCallerInfo);
    }

    public LogstashFieldNames getFieldNames() {
        return this.formatter.getFieldNames();
    }

    public void setFieldNames(LogstashFieldNames fieldNames) {
        this.formatter.setFieldNames(fieldNames);
    }

    public boolean isIncludeMdc() {
        return this.formatter.isIncludeMdc();
    }

    public void setIncludeMdc(boolean includeMdc) {
        this.formatter.setIncludeMdc(includeMdc);
    }

    public boolean isIncludeContext() {
        return this.formatter.isIncludeContext();
    }

    public void setIncludeContext(boolean includeContext) {
        this.formatter.setIncludeContext(includeContext);
    }
}

