/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.encoder;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.encoder.EncoderBase;
import ch.qos.logback.core.spi.ContextAware;
import java.io.IOException;
import net.logstash.logback.LogstashFormatter;
import net.logstash.logback.encoder.org.apache.commons.io.IOUtils;

public class LogstashEncoder
extends EncoderBase<ILoggingEvent> {
    private boolean immediateFlush = true;
    private final LogstashFormatter formatter = new LogstashFormatter();

    public void doEncode(ILoggingEvent event) throws IOException {
        IOUtils.write(this.formatter.writeValueAsBytes(event, this.getContext()), this.outputStream);
        IOUtils.write(CoreConstants.LINE_SEPARATOR, this.outputStream);
        if (this.immediateFlush) {
            this.outputStream.flush();
        }
    }

    public void close() throws IOException {
        IOUtils.write(IOUtils.LINE_SEPARATOR, this.outputStream);
    }

    public boolean isImmediateFlush() {
        return this.immediateFlush;
    }

    public void setImmediateFlush(boolean immediateFlush) {
        this.immediateFlush = immediateFlush;
    }

    public boolean isIncludeCallerInfo() {
        return this.formatter.isIncludeCallerInfo();
    }

    public void setIncludeCallerInfo(boolean includeCallerInfo) {
        this.formatter.setIncludeCallerInfo(includeCallerInfo);
    }

    public void setCustomFields(String customFields) {
        this.formatter.setCustomFieldsFromString(customFields, (ContextAware)this);
    }

    public String getCustomFields() {
        return this.formatter.getCustomFields().toString();
    }

    public void setEnableContextMap(boolean enableContextMap) {
        this.formatter.setEnableContextMap(enableContextMap);
    }

    public boolean isEnableContextMap() {
        return this.formatter.isEnableContextMap();
    }
}

