/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.log4j;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.logstash.log4j.data.HostData;
import net.minidev.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.FastDateFormat;
import org.apache.log4j.Layout;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;

public class JSONEventLayout
extends Layout {
    private boolean locationInfo = false;
    private String tags;
    private boolean ignoreThrowable;
    private boolean activeIgnoreThrowable = this.ignoreThrowable = false;
    private String hostname = new HostData().getHostName();
    private long timestamp;
    private String ndc;
    private Map mdc;
    private LocationInfo info;
    private HashMap<String, Object> fieldData;
    private HashMap<String, Object> exceptionInformation;
    private JSONObject logstashEvent;
    public static final FastDateFormat ISO_DATETIME_TIME_ZONE_FORMAT_WITH_MILLIS = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss.SSSZZ");

    public static String dateFormat(long timestamp) {
        return ISO_DATETIME_TIME_ZONE_FORMAT_WITH_MILLIS.format(new Date(timestamp));
    }

    public JSONEventLayout() {
        this(true);
    }

    public JSONEventLayout(boolean locationInfo) {
        this.locationInfo = locationInfo;
    }

    public String format(LoggingEvent loggingEvent) {
        this.timestamp = loggingEvent.getTimeStamp();
        this.fieldData = new HashMap();
        this.exceptionInformation = new HashMap();
        this.mdc = loggingEvent.getProperties();
        this.ndc = loggingEvent.getNDC();
        this.logstashEvent = new JSONObject();
        this.logstashEvent.put((Object)"@source_host", (Object)this.hostname);
        this.logstashEvent.put((Object)"@message", (Object)loggingEvent.getRenderedMessage());
        this.logstashEvent.put((Object)"@timestamp", (Object)JSONEventLayout.dateFormat(this.timestamp));
        if (loggingEvent.getThrowableInformation() != null) {
            ThrowableInformation throwableInformation = loggingEvent.getThrowableInformation();
            if (throwableInformation.getThrowable().getClass().getCanonicalName() != null) {
                this.exceptionInformation.put("exception_class", throwableInformation.getThrowable().getClass().getCanonicalName());
            }
            if (throwableInformation.getThrowable().getMessage() != null) {
                this.exceptionInformation.put("exception_message", throwableInformation.getThrowable().getMessage());
            }
            if (throwableInformation.getThrowableStrRep() != null) {
                String stackTrace = StringUtils.join((Object[])throwableInformation.getThrowableStrRep(), (String)"\n");
                this.exceptionInformation.put("stacktrace", stackTrace);
            }
            this.addFieldData("exception", this.exceptionInformation);
        }
        if (this.locationInfo) {
            this.info = loggingEvent.getLocationInformation();
            this.addFieldData("file", this.info.getFileName());
            this.addFieldData("line_number", this.info.getLineNumber());
            this.addFieldData("class", this.info.getClassName());
            this.addFieldData("method", this.info.getMethodName());
        }
        this.addFieldData("mdc", this.mdc);
        this.addFieldData("ndc", this.ndc);
        this.addFieldData("level", loggingEvent.getLevel().toString());
        this.logstashEvent.put((Object)"@fields", this.fieldData);
        return this.logstashEvent.toString() + "\n";
    }

    public boolean ignoresThrowable() {
        return this.ignoreThrowable;
    }

    public boolean getLocationInfo() {
        return this.locationInfo;
    }

    public void setLocationInfo(boolean locationInfo) {
        this.locationInfo = locationInfo;
    }

    public void activateOptions() {
        this.activeIgnoreThrowable = this.ignoreThrowable;
    }

    private void addFieldData(String keyname, Object keyval) {
        if (null != keyval) {
            this.fieldData.put(keyname, keyval);
        }
    }
}

