/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy.jetty.jetty.servlet.jmx;

import java.util.HashMap;
import javax.management.MBeanException;
import javax.management.ObjectName;
import net.lightbody.bmp.proxy.jetty.http.jmx.HttpHandlerMBean;
import net.lightbody.bmp.proxy.jetty.jetty.servlet.ServletHandler;
import net.lightbody.bmp.proxy.jetty.jetty.servlet.SessionManager;
import net.lightbody.bmp.proxy.jetty.log.LogFactory;
import org.apache.commons.logging.Log;

public class ServletHandlerMBean
extends HttpHandlerMBean {
    private static final Log log = LogFactory.getLog(ServletHandlerMBean.class);
    private ServletHandler _servletHandler;
    private HashMap _servletMap = new HashMap();

    @Override
    protected void defineManagedResource() {
        super.defineManagedResource();
        this.defineAttribute("usingCookies");
        this.defineAttribute("servlets", false, true);
        this.defineAttribute("sessionManager", false, true);
        this._servletHandler = (ServletHandler)this.getManagedResource();
    }

    public ObjectName getSessionManager() {
        SessionManager sm = this._servletHandler.getSessionManager();
        if (sm == null) {
            return null;
        }
        ObjectName[] on = this.getComponentMBeans(new Object[]{sm}, null);
        return on[0];
    }

    public ObjectName[] getServlets() {
        return this.getComponentMBeans(this._servletHandler.getServlets(), this._servletMap);
    }

    @Override
    public void postRegister(Boolean ok) {
        super.postRegister(ok);
        if (ok.booleanValue()) {
            this.getSessionManager();
        }
    }

    @Override
    public void postDeregister() {
        this.destroyComponentMBeans(this._servletMap);
        super.postDeregister();
    }
}

