/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy.jetty.http;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PrintStream;
import java.security.Principal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import net.lightbody.bmp.proxy.jetty.http.HttpRequest;
import net.lightbody.bmp.proxy.jetty.http.HttpResponse;
import net.lightbody.bmp.proxy.jetty.http.SSORealm;
import net.lightbody.bmp.proxy.jetty.http.UserRealm;
import net.lightbody.bmp.proxy.jetty.log.LogFactory;
import net.lightbody.bmp.proxy.jetty.util.Credential;
import net.lightbody.bmp.proxy.jetty.util.Password;
import net.lightbody.bmp.proxy.jetty.util.Resource;
import org.apache.commons.logging.Log;

public class HashUserRealm
extends HashMap
implements UserRealm,
SSORealm,
Externalizable {
    private static Log log = LogFactory.getLog(HashUserRealm.class);
    public static final String __SSO = "net.lightbody.bmp.proxy.jetty.http.SSO";
    private String _realmName;
    private String _config;
    protected HashMap _roles = new HashMap(7);
    private SSORealm _ssoRealm;

    public HashUserRealm() {
    }

    public HashUserRealm(String name) {
        this._realmName = name;
    }

    public HashUserRealm(String name, String config) throws IOException {
        this._realmName = name;
        this.load(config);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this._realmName);
        out.writeObject(this._config);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._realmName = (String)in.readObject();
        this._config = (String)in.readObject();
        if (this._config != null) {
            this.load(this._config);
        }
    }

    public void load(String config) throws IOException {
        this._config = config;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Load " + this + " from " + config));
        }
        Properties properties = new Properties();
        Resource resource = Resource.newResource(config);
        properties.load(resource.getInputStream());
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String username = entry.getKey().toString().trim();
            String credentials = entry.getValue().toString().trim();
            String roles = null;
            int c = credentials.indexOf(44);
            if (c > 0) {
                roles = credentials.substring(c + 1).trim();
                credentials = credentials.substring(0, c).trim();
            }
            if (username == null || username.length() <= 0 || credentials == null || credentials.length() <= 0) continue;
            this.put(username, credentials);
            if (roles == null || roles.length() <= 0) continue;
            StringTokenizer tok = new StringTokenizer(roles, ", ");
            while (tok.hasMoreTokens()) {
                this.addUserToRole(username, tok.nextToken());
            }
        }
    }

    public void setName(String name) {
        this._realmName = name;
    }

    @Override
    public String getName() {
        return this._realmName;
    }

    @Override
    public Principal getPrincipal(String username) {
        return (Principal)super.get(username);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Principal authenticate(String username, Object credentials, HttpRequest request) {
        KnownUser user;
        HashUserRealm hashUserRealm = this;
        synchronized (hashUserRealm) {
            user = (KnownUser)super.get(username);
        }
        if (user == null) {
            return null;
        }
        if (user.authenticate(credentials)) {
            return user;
        }
        return null;
    }

    @Override
    public void disassociate(Principal user) {
    }

    @Override
    public Principal pushRole(Principal user, String role) {
        if (user == null) {
            user = new User();
        }
        return new WrappedUser(user, role);
    }

    @Override
    public Principal popRole(Principal user) {
        WrappedUser wu = (WrappedUser)user;
        return wu.getUserPrincipal();
    }

    @Override
    public synchronized Object put(Object name, Object credentials) {
        if (credentials instanceof Principal) {
            return super.put(name.toString(), credentials);
        }
        if (credentials instanceof Password) {
            return super.put(name, new KnownUser(name.toString(), (Password)credentials));
        }
        if (credentials != null) {
            return super.put(name, new KnownUser(name.toString(), Credential.getCredential(credentials.toString())));
        }
        return null;
    }

    public synchronized void addUserToRole(String userName, String roleName) {
        HashSet<String> userSet = (HashSet<String>)this._roles.get(roleName);
        if (userSet == null) {
            userSet = new HashSet<String>(11);
            this._roles.put(roleName, userSet);
        }
        userSet.add(userName);
    }

    @Override
    public boolean reauthenticate(Principal user) {
        return ((User)user).isAuthenticated();
    }

    @Override
    public synchronized boolean isUserInRole(Principal user, String roleName) {
        if (user instanceof WrappedUser) {
            return ((WrappedUser)user).isUserInRole(roleName);
        }
        if (user == null || ((User)user).getUserRealm() != this) {
            return false;
        }
        HashSet userSet = (HashSet)this._roles.get(roleName);
        return userSet != null && userSet.contains(user.getName());
    }

    @Override
    public void logout(Principal user) {
    }

    @Override
    public String toString() {
        return "Realm[" + this._realmName + "]";
    }

    public void dump(PrintStream out) {
        out.println(this + ":");
        out.println(super.toString());
        out.println(this._roles);
    }

    public SSORealm getSSORealm() {
        return this._ssoRealm;
    }

    public void setSSORealm(SSORealm ssoRealm) {
        this._ssoRealm = ssoRealm;
    }

    @Override
    public Credential getSingleSignOn(HttpRequest request, HttpResponse response) {
        if (this._ssoRealm != null) {
            return this._ssoRealm.getSingleSignOn(request, response);
        }
        return null;
    }

    @Override
    public void setSingleSignOn(HttpRequest request, HttpResponse response, Principal principal, Credential credential) {
        if (this._ssoRealm != null) {
            this._ssoRealm.setSingleSignOn(request, response, principal, credential);
        }
    }

    @Override
    public void clearSingleSignOn(String username) {
        if (this._ssoRealm != null) {
            this._ssoRealm.clearSingleSignOn(username);
        }
    }

    private class WrappedUser
    extends User {
        private Principal user;
        private String role;

        WrappedUser(Principal user, String role) {
            this.user = user;
            this.role = role;
        }

        Principal getUserPrincipal() {
            return this.user;
        }

        @Override
        public String getName() {
            return "role:" + this.role;
        }

        @Override
        public boolean isAuthenticated() {
            return true;
        }

        public boolean isUserInRole(String role) {
            return this.role.equals(role);
        }
    }

    private class KnownUser
    extends User {
        private String _userName;
        private Credential _cred;

        KnownUser(String name, Credential credential) {
            this._userName = name;
            this._cred = credential;
        }

        boolean authenticate(Object credentials) {
            return this._cred != null && this._cred.check(credentials);
        }

        @Override
        public String getName() {
            return this._userName;
        }

        @Override
        public boolean isAuthenticated() {
            return true;
        }
    }

    private class User
    implements Principal {
        List roles = null;

        private User() {
        }

        private UserRealm getUserRealm() {
            return HashUserRealm.this;
        }

        @Override
        public String getName() {
            return "Anonymous";
        }

        public boolean isAuthenticated() {
            return false;
        }

        @Override
        public String toString() {
            return this.getName();
        }
    }
}

