/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.Date;
import net.lightbody.bmp.proxy.http.RequestInfo;
import org.java_bandwidthlimiter.StreamManager;

public class SimulatedSocket
extends Socket {
    private final StreamManager streamManager;

    public SimulatedSocket(StreamManager streamManager) {
        this.streamManager = streamManager;
    }

    @Override
    public void connect(SocketAddress endpoint) throws IOException {
        Date start = new Date();
        super.connect(endpoint);
        Date end = new Date();
        this.simulateLatency(start, end, this.streamManager);
    }

    @Override
    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        Date start = new Date();
        super.connect(endpoint, timeout);
        Date end = new Date();
        this.simulateLatency(start, end, this.streamManager);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.streamManager.registerStream(super.getInputStream());
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.streamManager.registerStream(super.getOutputStream());
    }

    private void simulateLatency(Date start, Date end, StreamManager streamManager) {
        Date realEnd = end;
        long connectReal = end.getTime() - start.getTime();
        if (connectReal < streamManager.getLatency()) {
            try {
                Thread.sleep(streamManager.getLatency() - connectReal);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            end = new Date();
        }
        RequestInfo.get().latency(start, realEnd);
        RequestInfo.get().connect(start, end);
    }
}

