/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Pattern;

public class Whitelist {
    private final Collection<Pattern> patterns;
    private final int responseCode;
    private final boolean enabled;
    public static final Whitelist WHITELIST_DISABLED = new Whitelist();

    public Whitelist() {
        this.patterns = Collections.emptyList();
        this.responseCode = -1;
        this.enabled = false;
    }

    public Whitelist(int responseCode) {
        this.patterns = Collections.emptyList();
        this.responseCode = responseCode;
        this.enabled = true;
    }

    public Whitelist(String[] patterns, int responseCode) {
        ArrayList<Pattern> patternList = new ArrayList<Pattern>(patterns.length);
        for (String pattern : patterns) {
            patternList.add(Pattern.compile(pattern));
        }
        this.patterns = Collections.unmodifiableList(patternList);
        this.responseCode = responseCode;
        this.enabled = true;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Collection<Pattern> getPatterns() {
        return this.patterns;
    }

    public int getResponseCode() {
        return this.responseCode;
    }
}

