/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy;

import java.util.regex.Pattern;

public class BlacklistEntry {
    private final Pattern pattern;
    private final int responseCode;
    private final Pattern method;

    public BlacklistEntry(String pattern, int responseCode) {
        this(pattern, responseCode, null);
    }

    public BlacklistEntry(String pattern, int responseCode, String method) {
        this.pattern = Pattern.compile(pattern);
        this.responseCode = responseCode;
        this.method = method == null || method.isEmpty() ? null : Pattern.compile(method);
    }

    public boolean matches(String url, String httpMethod) {
        if (this.method != null) {
            return this.pattern.matcher(url).matches() && this.method.matcher(httpMethod).matches();
        }
        return this.pattern.matcher(url).matches();
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public Pattern getMethod() {
        return this.method;
    }
}

