/*
 * Decompiled with CFR 0.152.
 */
package net.lapismc.afkplus.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.lapismc.afkplus.AFKPlus;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class EntitySpawnManager {
    private final AFKPlus plugin;
    private int spawnRange;

    public EntitySpawnManager(AFKPlus plugin) {
        this.plugin = plugin;
        try {
            YamlConfiguration spigotConfig = new YamlConfiguration();
            spigotConfig.load("spigot.yml");
            this.spawnRange = spigotConfig.getConfigurationSection("world-settings").getConfigurationSection("default").getInt("mob-spawn-range", 8);
        }
        catch (IOException | InvalidConfigurationException e) {
            this.spawnRange = 8;
        }
    }

    public boolean shouldSpawn(Location loc, CreatureSpawnEvent.SpawnReason reason) {
        List<Player> nearbyPlayers;
        if (reason.equals((Object)CreatureSpawnEvent.SpawnReason.NATURAL)) {
            nearbyPlayers = this.getPlayersInSquareRange(loc, this.spawnRange * 16, false);
        } else if (reason.equals((Object)CreatureSpawnEvent.SpawnReason.SPAWNER)) {
            nearbyPlayers = this.getPlayersInSquareRange(loc, 16, true);
        } else {
            return true;
        }
        for (Player p : nearbyPlayers) {
            if (this.plugin.getPlayer((OfflinePlayer)p).isAFK()) continue;
            return true;
        }
        return nearbyPlayers.size() == 0;
    }

    public List<Player> getPlayersInSquareRange(Location location, int range, boolean checkY) {
        List players = location.getWorld().getPlayers();
        ArrayList<Player> filteredPlayers = new ArrayList<Player>();
        for (Player player : players) {
            Location playerLocation = player.getLocation();
            if (player.getGameMode() == GameMode.SPECTATOR || Math.abs(playerLocation.getBlockX() - location.getBlockX()) >= range || Math.abs(playerLocation.getBlockZ() - location.getBlockZ()) >= range || checkY && Math.abs(playerLocation.getBlockY() - location.getBlockY()) >= range) continue;
            filteredPlayers.add(player);
        }
        return filteredPlayers;
    }
}

