/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.catalyst.buffer;

import net.kuujo.catalyst.buffer.AbstractBuffer;
import net.kuujo.catalyst.buffer.Buffer;
import net.kuujo.catalyst.buffer.BufferAllocator;
import net.kuujo.catalyst.util.ReferencePool;

public abstract class PooledAllocator
implements BufferAllocator {
    private final ReferencePool<AbstractBuffer> pool;

    protected PooledAllocator(ReferencePool<AbstractBuffer> pool) {
        this.pool = pool;
    }

    protected abstract long maxCapacity();

    @Override
    public Buffer allocate() {
        return this.allocate(4096L, this.maxCapacity());
    }

    @Override
    public Buffer allocate(long capacity) {
        return this.allocate(capacity, this.maxCapacity());
    }

    @Override
    public Buffer allocate(long initialCapacity, long maxCapacity) {
        return this.pool.acquire().reset(0L, initialCapacity, maxCapacity).clear();
    }
}

