/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.catalyst.buffer;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.kuujo.catalyst.buffer.Buffer;
import net.kuujo.catalyst.buffer.BufferOutput;
import net.kuujo.catalyst.buffer.Bytes;
import net.kuujo.catalyst.buffer.CatalystIOException;
import net.kuujo.catalyst.buffer.HeapBuffer;
import net.kuujo.catalyst.buffer.HeapBytes;

public class OutputStreamBufferOutput
implements BufferOutput {
    private final DataOutputStream os;

    public OutputStreamBufferOutput(OutputStream os) {
        this(new DataOutputStream(os));
    }

    public OutputStreamBufferOutput(DataOutputStream os) {
        if (os == null) {
            throw new NullPointerException("output stream cannot be null");
        }
        this.os = os;
    }

    public BufferOutput write(Bytes bytes) {
        if (bytes instanceof HeapBytes) {
            try {
                this.os.write(((HeapBytes)bytes).array());
            }
            catch (IOException e) {
                throw new CatalystIOException(e);
            }
        }
        byte[] buffer = new byte[(int)bytes.size()];
        bytes.read(0L, buffer, 0L, (long)buffer.length);
        try {
            this.os.write(buffer);
        }
        catch (IOException e) {
            throw new CatalystIOException(e);
        }
        return this;
    }

    public BufferOutput write(byte[] bytes) {
        try {
            this.os.write(bytes);
        }
        catch (IOException e) {
            throw new CatalystIOException(e);
        }
        return this;
    }

    public BufferOutput write(Bytes bytes, long offset, long length) {
        if (bytes instanceof HeapBytes) {
            try {
                this.os.write(((HeapBytes)bytes).array(), (int)offset, (int)length);
            }
            catch (IOException e) {
                throw new CatalystIOException(e);
            }
        }
        byte[] buffer = new byte[(int)bytes.size()];
        bytes.read(0L, buffer, 0L, (long)buffer.length);
        try {
            this.os.write(buffer, (int)offset, (int)length);
        }
        catch (IOException e) {
            throw new CatalystIOException(e);
        }
        return this;
    }

    public BufferOutput write(byte[] bytes, long offset, long length) {
        try {
            this.os.write(bytes, (int)offset, (int)length);
        }
        catch (IOException e) {
            throw new CatalystIOException(e);
        }
        return this;
    }

    public BufferOutput write(Buffer buffer) {
        if (buffer instanceof HeapBuffer) {
            try {
                this.os.write(((HeapBuffer)buffer).array());
            }
            catch (IOException e) {
                throw new CatalystIOException(e);
            }
        }
        byte[] bytes = new byte[(int)buffer.remaining()];
        buffer.read(bytes);
        try {
            this.os.write(bytes);
        }
        catch (IOException e) {
            throw new CatalystIOException(e);
        }
        return this;
    }

    public BufferOutput writeByte(int b) {
        try {
            this.os.writeByte(b);
        }
        catch (IOException e) {
            throw new CatalystIOException(e);
        }
        return this;
    }

    public BufferOutput writeUnsignedByte(int b) {
        try {
            this.os.writeByte(b);
        }
        catch (IOException e) {
            throw new CatalystIOException(e);
        }
        return this;
    }

    public BufferOutput writeChar(char c) {
        try {
            this.os.writeChar(c);
        }
        catch (IOException e) {
            throw new CatalystIOException(e);
        }
        return this;
    }

    public BufferOutput writeShort(short s) {
        try {
            this.os.writeShort(s);
        }
        catch (IOException e) {
            throw new CatalystIOException(e);
        }
        return this;
    }

    public BufferOutput writeUnsignedShort(int s) {
        try {
            this.os.writeShort(s);
        }
        catch (IOException e) {
            throw new CatalystIOException(e);
        }
        return this;
    }

    public BufferOutput writeMedium(int m) {
        try {
            this.os.writeByte((byte)(m >>> 16));
            this.os.writeByte((byte)(m >>> 8));
            this.os.writeByte((byte)m);
        }
        catch (IOException e) {
            throw new CatalystIOException(e);
        }
        return this;
    }

    public BufferOutput writeUnsignedMedium(int m) {
        return this.writeMedium(m);
    }

    public BufferOutput writeInt(int i) {
        try {
            this.os.writeInt(i);
        }
        catch (IOException e) {
            throw new CatalystIOException(e);
        }
        return this;
    }

    public BufferOutput writeUnsignedInt(long i) {
        try {
            this.os.writeInt((int)i);
        }
        catch (IOException e) {
            throw new CatalystIOException(e);
        }
        return this;
    }

    public BufferOutput writeLong(long l) {
        try {
            this.os.writeLong(l);
        }
        catch (IOException e) {
            throw new CatalystIOException(e);
        }
        return this;
    }

    public BufferOutput writeFloat(float f) {
        try {
            this.os.writeFloat(f);
        }
        catch (IOException e) {
            throw new CatalystIOException(e);
        }
        return this;
    }

    public BufferOutput writeDouble(double d) {
        try {
            this.os.writeDouble(d);
        }
        catch (IOException e) {
            throw new CatalystIOException(e);
        }
        return this;
    }

    public BufferOutput writeBoolean(boolean b) {
        try {
            this.os.writeBoolean(b);
        }
        catch (IOException e) {
            throw new CatalystIOException(e);
        }
        return this;
    }

    public BufferOutput writeString(String s) {
        try {
            this.os.writeUTF(s);
        }
        catch (IOException e) {
            throw new CatalystIOException(e);
        }
        return this;
    }

    public BufferOutput writeUTF8(String s) {
        try {
            this.os.writeUTF(s);
        }
        catch (IOException e) {
            throw new CatalystIOException(e);
        }
        return this;
    }

    public BufferOutput flush() {
        try {
            this.os.flush();
        }
        catch (IOException e) {
            throw new CatalystIOException(e);
        }
        return this;
    }

    @Override
    public void close() {
        try {
            this.os.close();
        }
        catch (IOException e) {
            throw new CatalystIOException(e);
        }
    }
}

