/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.catalyst.buffer;

import java.io.File;
import java.nio.channels.FileChannel;
import net.kuujo.catalyst.buffer.Buffer;
import net.kuujo.catalyst.buffer.MappedBytes;
import net.kuujo.catalyst.buffer.NativeBuffer;
import net.kuujo.catalyst.buffer.util.MappedMemory;
import net.kuujo.catalyst.buffer.util.MappedMemoryAllocator;
import net.kuujo.catalyst.buffer.util.Memory;
import net.kuujo.catalyst.util.ReferenceManager;

public class MappedBuffer
extends NativeBuffer {
    private static final long DEFAULT_INITIAL_CAPACITY = 0x1000000L;

    public static MappedBuffer allocate(File file) {
        return MappedBuffer.allocate(file, MappedMemoryAllocator.DEFAULT_MAP_MODE, 0x1000000L, Long.MAX_VALUE);
    }

    public static MappedBuffer allocate(File file, FileChannel.MapMode mode) {
        return MappedBuffer.allocate(file, mode, 0x1000000L, Long.MAX_VALUE);
    }

    public static MappedBuffer allocate(File file, long capacity) {
        return MappedBuffer.allocate(file, MappedMemoryAllocator.DEFAULT_MAP_MODE, capacity, capacity);
    }

    public static MappedBuffer allocate(File file, FileChannel.MapMode mode, long capacity) {
        return MappedBuffer.allocate(file, mode, capacity, capacity);
    }

    public static MappedBuffer allocate(File file, long initialCapacity, long maxCapacity) {
        return MappedBuffer.allocate(file, MappedMemoryAllocator.DEFAULT_MAP_MODE, initialCapacity, maxCapacity);
    }

    public static MappedBuffer allocate(File file, FileChannel.MapMode mode, long initialCapacity, long maxCapacity) {
        if (file == null) {
            throw new NullPointerException("file cannot be null");
        }
        if (mode == null) {
            mode = MappedMemoryAllocator.DEFAULT_MAP_MODE;
        }
        if (initialCapacity > maxCapacity) {
            throw new IllegalArgumentException("initial capacity cannot be greater than maximum capacity");
        }
        if (initialCapacity > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("initial capacity for MappedBuffer cannot be greater than 2147483647");
        }
        if (maxCapacity > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("maximum capacity for MappedBuffer cannot be greater than 2147483647");
        }
        return new MappedBuffer(new MappedBytes(file, MappedMemory.allocate(file, mode, Memory.Util.toPow2(initialCapacity))), 0L, initialCapacity, maxCapacity);
    }

    protected MappedBuffer(MappedBytes bytes, ReferenceManager<Buffer> referenceManager) {
        super(bytes, referenceManager);
    }

    MappedBuffer(MappedBytes bytes, long offset, long initialCapacity, long maxCapacity) {
        super(bytes, offset, initialCapacity, maxCapacity);
    }

    public void delete() {
        ((MappedBytes)this.bytes).delete();
    }
}

