/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.catalyst.buffer;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import net.kuujo.catalyst.buffer.Bytes;
import net.kuujo.catalyst.buffer.SwappedBytes;

public abstract class AbstractBytes
implements Bytes {
    private boolean open = true;
    private SwappedBytes swap;

    protected void checkOpen() {
        if (!this.open) {
            throw new IllegalStateException("bytes not open");
        }
    }

    protected void checkOffset(long offset) {
        this.checkOpen();
        if (offset < 0L || offset > this.size()) {
            throw new IndexOutOfBoundsException();
        }
    }

    protected long checkRead(long offset, long length) {
        this.checkOffset(offset);
        long position = offset + length;
        if (position > this.size()) {
            throw new BufferUnderflowException();
        }
        return position;
    }

    protected long checkWrite(long offset, long length) {
        this.checkOffset(offset);
        long position = offset + length;
        if (position > this.size()) {
            throw new BufferOverflowException();
        }
        return position;
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public boolean isFile() {
        return false;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.BIG_ENDIAN;
    }

    @Override
    public Bytes order(ByteOrder order) {
        if (order == null) {
            throw new NullPointerException("order cannot be null");
        }
        if (order == this.order()) {
            return this;
        }
        if (this.swap != null) {
            return this.swap;
        }
        this.swap = new SwappedBytes(this);
        return this.swap;
    }

    @Override
    public void close() {
        this.open = false;
    }
}

