/*
 * Decompiled with CFR 0.152.
 */
package net.kaczmarzyk.spring.data.jpa.domain;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import net.kaczmarzyk.spring.data.jpa.domain.Fake;
import net.kaczmarzyk.spring.data.jpa.utils.JoinPathUtils;
import net.kaczmarzyk.spring.data.jpa.utils.QueryContext;
import org.springframework.data.jpa.domain.Specification;

public class Join<T>
implements Specification<T>,
Fake {
    private static final long serialVersionUID = 1L;
    private String pathToJoinOn;
    private String alias;
    private JoinType joinType;
    private QueryContext queryContext;
    private boolean distinctQuery;

    public Join(QueryContext queryContext, String pathToJoinOn, String alias, JoinType joinType, boolean distinctQuery) {
        this.pathToJoinOn = pathToJoinOn;
        this.alias = alias;
        this.joinType = joinType;
        this.queryContext = queryContext;
        this.distinctQuery = distinctQuery;
    }

    public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder builder) {
        query.distinct(this.distinctQuery);
        if (!JoinPathUtils.pathToJoinContainsAlias(this.pathToJoinOn)) {
            this.queryContext.putLazyVal(this.alias, r -> r.join(this.pathToJoinOn, this.joinType));
        } else {
            String[] pathToJoinOnSplittedByDot = JoinPathUtils.pathToJoinSplittedByDot(this.pathToJoinOn);
            String extractedAlias = pathToJoinOnSplittedByDot[0];
            javax.persistence.criteria.Join<?, ?> evaluated = this.queryContext.getEvaluated(extractedAlias, root);
            if (evaluated == null) {
                throw new IllegalArgumentException("Join definition with alias: '" + extractedAlias + "' not found! Make sure that join with the alias '" + extractedAlias + "' is defined before the join with path: '" + this.pathToJoinOn + "'");
            }
            String extractedPathToJoin = pathToJoinOnSplittedByDot[1];
            this.queryContext.putLazyVal(this.alias, r -> evaluated.join(extractedPathToJoin, this.joinType));
        }
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.alias == null ? 0 : this.alias.hashCode());
        result = 31 * result + (this.distinctQuery ? 1231 : 1237);
        result = 31 * result + (this.joinType == null ? 0 : this.joinType.hashCode());
        result = 31 * result + (this.pathToJoinOn == null ? 0 : this.pathToJoinOn.hashCode());
        result = 31 * result + (this.queryContext == null ? 0 : this.queryContext.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Join other = (Join)obj;
        if (this.alias == null ? other.alias != null : !this.alias.equals(other.alias)) {
            return false;
        }
        if (this.distinctQuery != other.distinctQuery) {
            return false;
        }
        if (this.joinType != other.joinType) {
            return false;
        }
        if (this.pathToJoinOn == null ? other.pathToJoinOn != null : !this.pathToJoinOn.equals(other.pathToJoinOn)) {
            return false;
        }
        return !(this.queryContext == null ? other.queryContext != null : !this.queryContext.equals(other.queryContext));
    }

    public String toString() {
        return "Join [pathToJoinOn=" + this.pathToJoinOn + ", alias=" + this.alias + ", joinType=" + this.joinType + ", queryContext=" + this.queryContext + ", distinctQuery=" + this.distinctQuery + "]";
    }
}

