/*
 * Decompiled with CFR 0.152.
 */
package net.kaczmarzyk.spring.data.jpa.domain;

import java.util.Objects;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import net.kaczmarzyk.spring.data.jpa.domain.PathSpecification;
import net.kaczmarzyk.spring.data.jpa.utils.Converter;
import net.kaczmarzyk.spring.data.jpa.utils.QueryContext;

public class Between<T>
extends PathSpecification<T> {
    private static final long serialVersionUID = 1L;
    private final String lowerBoundaryStr;
    private final String upperBoundaryStr;
    private final Converter converter;

    public Between(QueryContext queryContext, String path, String[] args, Converter converter) {
        super(queryContext, path);
        if (args == null || args.length != 2) {
            throw new IllegalArgumentException("expected 2 http params (lower and upper boundaries), but was: " + args);
        }
        this.converter = converter;
        this.lowerBoundaryStr = args[0];
        this.upperBoundaryStr = args[1];
    }

    public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder criteriaBuilder) {
        Path targetExpression = this.path(root);
        Class typeOnPath = targetExpression.getJavaType();
        Comparable lowerBoundary = (Comparable)this.converter.convert(this.lowerBoundaryStr, typeOnPath);
        Comparable upperBoundary = (Comparable)this.converter.convert(this.upperBoundaryStr, typeOnPath);
        return criteriaBuilder.between(targetExpression, lowerBoundary, upperBoundary);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Between between = (Between)o;
        return Objects.equals(this.lowerBoundaryStr, between.lowerBoundaryStr) && Objects.equals(this.upperBoundaryStr, between.upperBoundaryStr) && Objects.equals(this.converter, between.converter);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.lowerBoundaryStr, this.upperBoundaryStr, this.converter);
    }

    public String toString() {
        return "Between[lowerBoundaryStr='" + this.lowerBoundaryStr + '\'' + ", upperBoundaryStr='" + this.upperBoundaryStr + '\'' + ", converter=" + this.converter + ']';
    }
}

