/*
 * Decompiled with CFR 0.152.
 */
package net.kaczmarzyk.spring.data.jpa.web;

import java.lang.reflect.Field;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.data.jpa.domain.Specification;

abstract class EnhancerUtil {
    EnhancerUtil() {
    }

    static <T> T wrapWithIfaceImplementation(Class<T> iface, Specification<Object> targetSpec) {
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(iface);
        enhancer.setCallback((Callback)((MethodInterceptor)(obj, method, args, proxy) -> {
            if ("toString".equals(method.getName())) {
                return iface.getSimpleName() + "[" + method.invoke((Object)targetSpec, args) + "]";
            }
            if ("equals".equals(method.getName())) {
                return EnhancerUtil.equals(iface, targetSpec, args);
            }
            if ("hashCode".equals(method.getName())) {
                return targetSpec.hashCode();
            }
            return proxy.invoke((Object)targetSpec, args);
        }));
        return (T)enhancer.create();
    }

    private static boolean equals(Class<?> iface, Specification<Object> targetSpec, Object[] args) {
        if (args.length != 1 || args[0] == null) {
            return false;
        }
        if (!Enhancer.isEnhanced(args[0].getClass())) {
            return false;
        }
        if (!EnhancerUtil.isAnObjectThatDirectImplementsGivenInterface(args[0], iface)) {
            return false;
        }
        return ReflectionUtils.get(ReflectionUtils.get(args[0], "CGLIB$CALLBACK_0"), "arg$2").equals(targetSpec);
    }

    private static boolean isAnObjectThatDirectImplementsGivenInterface(Object object, Class<?> expectedType) {
        return EnhancerUtil.arrayContains(object.getClass().getInterfaces(), expectedType);
    }

    private static boolean arrayContains(Class<?>[] array, Class<?> valueToFind) {
        for (Class<?> arrayValue : array) {
            if (!arrayValue.equals(valueToFind)) continue;
            return true;
        }
        return false;
    }

    private static final class ReflectionUtils {
        private ReflectionUtils() {
        }

        static <T> T get(Object target, String fieldname) {
            try {
                Class<?> classToBeUsed = target.getClass();
                while (true) {
                    try {
                        Field f = classToBeUsed.getDeclaredField(fieldname);
                        f.setAccessible(true);
                        return (T)f.get(target);
                    }
                    catch (NoSuchFieldException err) {
                        classToBeUsed = classToBeUsed.getSuperclass();
                        if (classToBeUsed != Object.class) continue;
                        throw err;
                        if (classToBeUsed != Object.class) continue;
                        throw new NoSuchFieldException();
                    }
                    break;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

