/*
 * Decompiled with CFR 0.152.
 */
package net.kaczmarzyk.spring.data.jpa.domain;

import java.util.Objects;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Root;
import net.kaczmarzyk.spring.data.jpa.utils.QueryContext;
import org.springframework.data.jpa.domain.Specification;

public abstract class PathSpecification<T>
implements Specification<T> {
    private static final long serialVersionUID = 1L;
    protected String path;
    private QueryContext queryContext;

    public PathSpecification(QueryContext queryContext, String path) {
        this.queryContext = queryContext;
        this.path = path;
    }

    protected <F> Path<F> path(Root<T> root) {
        Path<T> expr = null;
        for (String field : this.path.split("\\.")) {
            if (expr == null) {
                if (this.queryContext != null && this.getEvaluatedPath(field, root) != null) {
                    expr = this.getEvaluatedPath(field, root);
                    continue;
                }
                expr = root.get(field);
                continue;
            }
            expr = expr.get(field);
        }
        return expr;
    }

    private Path<T> getEvaluatedPath(String field, Root<T> root) {
        Join<?, ?> evaluated = this.queryContext.getEvaluated(field, root);
        if (evaluated == null) {
            return (Path)this.queryContext.getEvaluatedJoinFetch(field);
        }
        return evaluated;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 31 * result + (this.queryContext == null ? 0 : this.queryContext.hashCode());
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PathSpecification that = (PathSpecification)o;
        return Objects.equals(this.path, that.path) && Objects.equals(this.queryContext, that.queryContext);
    }
}

