/*
 * Decompiled with CFR 0.152.
 */
package net.kaczmarzyk.spring.data.jpa.web;

import java.util.ArrayList;
import net.kaczmarzyk.spring.data.jpa.domain.Disjunction;
import net.kaczmarzyk.spring.data.jpa.web.SimpleSpecificationResolver;
import net.kaczmarzyk.spring.data.jpa.web.annotation.Or;
import net.kaczmarzyk.spring.data.jpa.web.annotation.Spec;
import org.springframework.core.MethodParameter;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

class OrSpecificationResolver
implements HandlerMethodArgumentResolver {
    private SimpleSpecificationResolver specResolver = new SimpleSpecificationResolver();

    OrSpecificationResolver() {
    }

    public boolean supportsParameter(MethodParameter param) {
        return param.getParameterType() == Specification.class && param.hasParameterAnnotation(Or.class);
    }

    public Specification<?> resolveArgument(MethodParameter param, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        Or def = (Or)param.getParameterAnnotation(Or.class);
        return this.buildSpecification(webRequest, def);
    }

    Specification<Object> buildSpecification(NativeWebRequest webRequest, Or def) {
        ArrayList innerSpecs = new ArrayList();
        for (Spec innerDef : def.value()) {
            Specification<Object> innerSpec = this.specResolver.buildSpecification(webRequest, innerDef);
            if (innerSpec == null) continue;
            innerSpecs.add(this.specResolver.buildSpecification(webRequest, innerDef));
        }
        return innerSpecs.isEmpty() ? null : new Disjunction(innerSpecs);
    }
}

