/*
 * Decompiled with CFR 0.152.
 */
package net.jsign;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.jsign.Console;
import net.jsign.DigestAlgorithm;
import net.jsign.KeyStoreUtils;
import net.jsign.PESigner;
import net.jsign.PrivateKeyUtils;
import net.jsign.SignerException;
import net.jsign.pe.PEFile;
import net.jsign.timestamp.TimestampingMode;

class PESignerHelper {
    public static final String PARAM_KEYSTORE = "keystore";
    public static final String PARAM_STOREPASS = "storepass";
    public static final String PARAM_STORETYPE = "storetype";
    public static final String PARAM_ALIAS = "alias";
    public static final String PARAM_KEYPASS = "keypass";
    public static final String PARAM_KEYFILE = "keyfile";
    public static final String PARAM_CERTFILE = "certfile";
    public static final String PARAM_ALG = "alg";
    public static final String PARAM_TSAURL = "tsaurl";
    public static final String PARAM_TSMODE = "tsmode";
    public static final String PARAM_TSRETRIES = "tsretries";
    public static final String PARAM_TSRETRY_WAIT = "tsretrywait";
    public static final String PARAM_NAME = "name";
    public static final String PARAM_URL = "url";
    public static final String PARAM_PROXY_URL = "proxyUrl";
    public static final String PARAM_PROXY_USER = "proxyUser";
    public static final String PARAM_PROXY_PASS = "proxyPass";
    public static final String PARAM_REPLACE = "replace";
    private Console console;
    private String parameterName = "parameter";
    private File keystore;
    private String storepass;
    private String storetype;
    private String alias;
    private String keypass;
    private File keyfile;
    private File certfile;
    private String tsaurl;
    private String tsmode;
    private int tsretries = -1;
    private int tsretrywait = -1;
    private String alg;
    private String name;
    private String url;
    private String proxyUrl;
    private String proxyUser;
    private String proxyPass;
    private boolean replace;

    public PESignerHelper(Console console, String parameterName) {
        this.console = console;
        this.parameterName = parameterName;
    }

    public PESignerHelper keystore(String keystore) {
        this.keystore(this.createFile(keystore));
        return this;
    }

    public PESignerHelper keystore(File keystore) {
        this.keystore = keystore;
        return this;
    }

    public PESignerHelper storepass(String storepass) {
        this.storepass = storepass;
        return this;
    }

    public PESignerHelper storetype(String storetype) {
        this.storetype = storetype;
        return this;
    }

    public PESignerHelper alias(String alias) {
        this.alias = alias;
        return this;
    }

    public PESignerHelper keypass(String keypass) {
        this.keypass = keypass;
        return this;
    }

    public PESignerHelper keyfile(String keyfile) {
        this.keyfile(this.createFile(keyfile));
        return this;
    }

    public PESignerHelper keyfile(File keyfile) {
        this.keyfile = keyfile;
        return this;
    }

    public PESignerHelper certfile(String certfile) {
        this.certfile(this.createFile(certfile));
        return this;
    }

    public PESignerHelper certfile(File certfile) {
        this.certfile = certfile;
        return this;
    }

    public PESignerHelper alg(String alg) {
        this.alg = alg;
        return this;
    }

    public PESignerHelper tsaurl(String tsaurl) {
        this.tsaurl = tsaurl;
        return this;
    }

    public PESignerHelper tsmode(String tsmode) {
        this.tsmode = tsmode;
        return this;
    }

    public PESignerHelper tsretries(int tsretries) {
        this.tsretries = tsretries;
        return this;
    }

    public PESignerHelper tsretrywait(int tsretrywait) {
        this.tsretrywait = tsretrywait;
        return this;
    }

    public PESignerHelper name(String name) {
        this.name = name;
        return this;
    }

    public PESignerHelper url(String url) {
        this.url = url;
        return this;
    }

    public PESignerHelper proxyUrl(String proxyUrl) {
        this.proxyUrl = proxyUrl;
        return this;
    }

    public PESignerHelper proxyUser(String proxyUser) {
        this.proxyUser = proxyUser;
        return this;
    }

    public PESignerHelper proxyPass(String proxyPass) {
        this.proxyPass = proxyPass;
        return this;
    }

    public PESignerHelper replace(boolean replace) {
        this.replace = replace;
        return this;
    }

    public PESignerHelper param(String key, String value) {
        if (value == null) {
            return this;
        }
        switch (key) {
            case "keystore": {
                return this.keystore(value);
            }
            case "storepass": {
                return this.storepass(value);
            }
            case "storetype": {
                return this.storetype(value);
            }
            case "alias": {
                return this.alias(value);
            }
            case "keypass": {
                return this.keypass(value);
            }
            case "keyfile": {
                return this.keyfile(value);
            }
            case "certfile": {
                return this.certfile(value);
            }
            case "alg": {
                return this.alg(value);
            }
            case "tsaurl": {
                return this.tsaurl(value);
            }
            case "tsmode": {
                return this.tsmode(value);
            }
            case "tsretries": {
                return this.tsretries(Integer.parseInt(value));
            }
            case "tsretrywait": {
                return this.tsretrywait(Integer.parseInt(value));
            }
            case "name": {
                return this.name(value);
            }
            case "url": {
                return this.url(value);
            }
            case "proxyUrl": {
                return this.proxyUrl(value);
            }
            case "proxyUser": {
                return this.proxyUser(value);
            }
            case "proxyPass": {
                return this.proxyPass(value);
            }
            case "replace": {
                return this.replace("true".equalsIgnoreCase(value));
            }
        }
        throw new IllegalArgumentException("Unknown " + this.parameterName + ": " + key);
    }

    private File createFile(String file) {
        return file == null ? null : new File(file);
    }

    public PESigner build() throws SignerException {
        PrivateKey privateKey;
        Certificate[] chain;
        if (this.keystore == null && this.keyfile == null && this.certfile == null) {
            throw new SignerException("keystore " + this.parameterName + ", or keyfile and certfile " + this.parameterName + "s must be set");
        }
        if (this.keystore != null && (this.keyfile != null || this.certfile != null)) {
            throw new SignerException("keystore " + this.parameterName + " can't be mixed with keyfile or certfile");
        }
        Provider provider = null;
        if ("PKCS11".equals(this.storetype)) {
            if (this.keystore != null && this.keystore.exists()) {
                provider = this.createSunPKCS11Provider(this.keystore);
            } else if (this.keystore != null && this.keystore.getName().startsWith("SunPKCS11-")) {
                provider = Security.getProvider(this.keystore.getName());
                if (provider == null) {
                    throw new SignerException("Security provider " + this.keystore.getName() + " not found");
                }
            } else {
                throw new SignerException("keystore " + this.parameterName + " should either refer to the SunPKCS11 configuration file or to the name of the provider configured in jre/lib/security/java.security");
            }
        }
        if (this.keystore != null) {
            KeyStore ks;
            try {
                ks = KeyStoreUtils.load(this.keystore, this.storetype, this.storepass, provider);
            }
            catch (KeyStoreException e) {
                throw new SignerException(e.getMessage(), e);
            }
            if (this.alias == null) {
                throw new SignerException("alias " + this.parameterName + " must be set");
            }
            try {
                chain = ks.getCertificateChain(this.alias);
            }
            catch (KeyStoreException e) {
                throw new SignerException(e.getMessage(), e);
            }
            if (chain == null) {
                throw new SignerException("No certificate found under the alias '" + this.alias + "' in the keystore " + (provider != null ? provider.getName() : this.keystore));
            }
            char[] password = this.keypass != null ? this.keypass.toCharArray() : this.storepass.toCharArray();
            try {
                privateKey = (PrivateKey)ks.getKey(this.alias, password);
            }
            catch (Exception e) {
                throw new SignerException("Failed to retrieve the private key from the keystore", e);
            }
        }
        if (this.keyfile == null) {
            throw new SignerException("keyfile " + this.parameterName + " must be set");
        }
        if (!this.keyfile.exists()) {
            throw new SignerException("The keyfile " + this.keyfile + " couldn't be found");
        }
        if (this.certfile == null) {
            throw new SignerException("certfile " + this.parameterName + " must be set");
        }
        if (!this.certfile.exists()) {
            throw new SignerException("The certfile " + this.certfile + " couldn't be found");
        }
        try {
            chain = this.loadCertificateChain(this.certfile);
        }
        catch (Exception e) {
            throw new SignerException("Failed to load the certificate from " + this.certfile, e);
        }
        try {
            privateKey = PrivateKeyUtils.load(this.keyfile, this.keypass != null ? this.keypass : this.storepass);
        }
        catch (Exception e) {
            throw new SignerException("Failed to load the private key from " + this.keyfile, e);
        }
        if (this.alg != null && DigestAlgorithm.of(this.alg) == null) {
            throw new SignerException("The digest algorithm " + this.alg + " is not supported");
        }
        try {
            this.initializeProxy(this.proxyUrl, this.proxyUser, this.proxyPass);
        }
        catch (Exception e) {
            throw new SignerException("Couldn't initialize proxy ", e);
        }
        return new PESigner(chain, privateKey).withProgramName(this.name).withProgramURL(this.url).withDigestAlgorithm(DigestAlgorithm.of(this.alg)).withSignatureProvider(provider).withSignaturesReplaced(this.replace).withTimestamping(this.tsaurl != null || this.tsmode != null).withTimestampingMode(this.tsmode != null ? TimestampingMode.of(this.tsmode) : TimestampingMode.AUTHENTICODE).withTimestampingRetries(this.tsretries).withTimestampingRetryWait(this.tsretrywait).withTimestampingAuthority(this.tsaurl != null ? this.tsaurl.split(",") : null);
    }

    private Provider createSunPKCS11Provider(File configuration) throws SignerException {
        try {
            try {
                Method providerConfigureMethod = Provider.class.getMethod("configure", String.class);
                Provider provider = Security.getProvider("SunPKCS11");
                return (Provider)providerConfigureMethod.invoke((Object)provider, configuration.getPath());
            }
            catch (NoSuchMethodException e) {
                Constructor<?> sunpkcs11Constructor = Class.forName("sun.security.pkcs11.SunPKCS11").getConstructor(String.class);
                return (Provider)sunpkcs11Constructor.newInstance(configuration.getPath());
            }
        }
        catch (Exception e) {
            throw new SignerException("Failed to create a SunPKCS11 provider from the configuration file " + configuration, e);
        }
    }

    public void sign(File file) throws SignerException {
        PEFile peFile;
        PESigner signer;
        try {
            signer = this.build();
        }
        catch (SignerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SignerException("Couldn't sign " + file, e);
        }
        if (file == null) {
            throw new SignerException("file must be set");
        }
        if (!file.exists()) {
            throw new SignerException("The file " + file + " couldn't be found");
        }
        try {
            peFile = new PEFile(file);
        }
        catch (IOException e) {
            throw new SignerException("Couldn't open the executable file " + file, e);
        }
        try {
            if (this.console != null) {
                this.console.info("Adding Authenticode signature to " + file);
            }
            signer.sign(peFile);
        }
        catch (Exception e) {
            throw new SignerException("Couldn't sign " + file, e);
        }
        finally {
            block18: {
                try {
                    peFile.close();
                }
                catch (IOException e) {
                    if (this.console == null) break block18;
                    this.console.warn("Couldn't close " + file, e);
                }
            }
        }
    }

    private Certificate[] loadCertificateChain(File file) throws IOException, CertificateException {
        try (FileInputStream in = new FileInputStream(file);){
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            Collection<? extends Certificate> certificates = certificateFactory.generateCertificates(in);
            Certificate[] certificateArray = certificates.toArray(new Certificate[certificates.size()]);
            return certificateArray;
        }
    }

    private void initializeProxy(String proxyUrl, final String proxyUser, final String proxyPassword) throws MalformedURLException {
        if (proxyUrl != null && proxyUrl.trim().length() > 0) {
            URL url;
            if (!proxyUrl.trim().startsWith("http")) {
                proxyUrl = "http://" + proxyUrl.trim();
            }
            final int port = (url = new URL(proxyUrl)).getPort() < 0 ? 80 : url.getPort();
            ProxySelector.setDefault(new ProxySelector(){
                private List<Proxy> proxies;
                {
                    this.proxies = Collections.singletonList(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(url.getHost(), port)));
                }

                @Override
                public List<Proxy> select(URI uri) {
                    return this.proxies;
                }

                @Override
                public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
                }
            });
            if (proxyUser != null && proxyUser.length() > 0 && proxyPassword != null) {
                Authenticator.setDefault(new Authenticator(){

                    @Override
                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(proxyUser, proxyPassword.toCharArray());
                    }
                });
            }
        }
    }
}

