/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.time.internal.properties.arbitraries.valueRanges;

import java.time.LocalDate;
import java.time.Year;
import net.jqwik.time.internal.properties.arbitraries.valueRanges.Between;
import net.jqwik.time.internal.properties.arbitraries.valueRanges.YearBetween;

public class LocalDateBetween
extends Between<LocalDate> {
    @Override
    protected void checkValidity(LocalDate min, LocalDate max) {
        if (min != null && min.getYear() <= 0 || max != null && max.getYear() <= 0) {
            throw new IllegalArgumentException("Minimum year in a date must be > 0");
        }
    }

    public void setYearBetween(YearBetween yearBetween) {
        LocalDate min = LocalDate.of(((Year)yearBetween.getMin()).getValue(), 1, 1);
        LocalDate max = LocalDate.of(((Year)yearBetween.getMax()).getValue(), 12, 31);
        this.set(min, max);
    }
}

