/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.time.internal.properties.arbitraries;

import java.time.Month;
import java.time.Year;
import java.time.YearMonth;
import java.time.temporal.ChronoUnit;
import net.jqwik.api.Arbitraries;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.RandomDistribution;
import net.jqwik.api.arbitraries.ArbitraryDecorator;
import net.jqwik.api.arbitraries.LongArbitrary;
import net.jqwik.time.api.arbitraries.YearMonthArbitrary;
import net.jqwik.time.internal.properties.arbitraries.valueRanges.AllowedMonths;
import net.jqwik.time.internal.properties.arbitraries.valueRanges.MonthBetween;
import net.jqwik.time.internal.properties.arbitraries.valueRanges.YearBetween;
import net.jqwik.time.internal.properties.arbitraries.valueRanges.YearMonthBetween;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL)
public class DefaultYearMonthArbitrary
extends ArbitraryDecorator<YearMonth>
implements YearMonthArbitrary {
    private static final YearMonth DEFAULT_MIN = YearMonth.of(1900, 1);
    private static final YearMonth DEFAULT_MAX = YearMonth.of(2500, 12);
    private final YearMonthBetween yearMonthBetween = new YearMonthBetween();
    private final AllowedMonths allowedMonths = new AllowedMonths();

    protected Arbitrary<YearMonth> arbitrary() {
        YearMonth effectiveMin = this.yearMonthBetween.getMin() == null ? DEFAULT_MIN : (YearMonth)this.yearMonthBetween.getMin();
        YearMonth effectiveMax = this.yearMonthBetween.getMax() == null ? DEFAULT_MAX : (YearMonth)this.yearMonthBetween.getMax();
        long months = ChronoUnit.MONTHS.between(effectiveMin, effectiveMax);
        Arbitrary month = ((LongArbitrary)Arbitraries.longs().between(0L, months).withDistribution(RandomDistribution.uniform())).edgeCases(edgeCases -> edgeCases.includeOnly((Object[])new Long[]{0L, months}));
        Arbitrary yearMonths = month.map(effectiveMin::plusMonths);
        if (this.allowedMonths.get().size() < 12) {
            yearMonths = yearMonths.filter(yearMonth -> this.allowedMonths.get().contains(yearMonth.getMonth()));
        }
        return yearMonths;
    }

    @Override
    public YearMonthArbitrary atTheEarliest(YearMonth min) {
        DefaultYearMonthArbitrary clone = (DefaultYearMonthArbitrary)this.typedClone();
        clone.yearMonthBetween.set(min, null);
        return clone;
    }

    @Override
    public YearMonthArbitrary atTheLatest(YearMonth max) {
        DefaultYearMonthArbitrary clone = (DefaultYearMonthArbitrary)this.typedClone();
        clone.yearMonthBetween.set(null, max);
        return clone;
    }

    @Override
    public YearMonthArbitrary yearBetween(Year min, Year max) {
        YearBetween yearBetween = (YearBetween)new YearBetween().set(min, max);
        DefaultYearMonthArbitrary clone = (DefaultYearMonthArbitrary)this.typedClone();
        clone.yearMonthBetween.setYearBetween(yearBetween);
        return clone;
    }

    @Override
    public YearMonthArbitrary monthBetween(Month min, Month max) {
        MonthBetween monthBetween = (MonthBetween)new MonthBetween().set(min, max);
        DefaultYearMonthArbitrary clone = (DefaultYearMonthArbitrary)this.typedClone();
        clone.allowedMonths.set(monthBetween);
        return clone;
    }

    @Override
    public YearMonthArbitrary onlyMonths(Month ... months) {
        DefaultYearMonthArbitrary clone = (DefaultYearMonthArbitrary)this.typedClone();
        clone.allowedMonths.set(months);
        return clone;
    }
}

