/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.api.footnotes;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.jqwik.api.Tuple;
import net.jqwik.api.footnotes.Footnotes;
import net.jqwik.api.lifecycle.AroundTryHook;
import net.jqwik.api.lifecycle.LifecycleContext;
import net.jqwik.api.lifecycle.Lifespan;
import net.jqwik.api.lifecycle.ParameterResolutionContext;
import net.jqwik.api.lifecycle.PropagationMode;
import net.jqwik.api.lifecycle.RegistrarHook;
import net.jqwik.api.lifecycle.ResolveParameterHook;
import net.jqwik.api.lifecycle.Store;
import net.jqwik.api.lifecycle.TryExecutionResult;
import net.jqwik.api.lifecycle.TryExecutor;
import net.jqwik.api.lifecycle.TryLifecycleContext;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL)
class FootnotesHook
implements RegistrarHook {
    FootnotesHook() {
    }

    private static Store<FootnotesCollector> getFootnotesCollectorStore() {
        return Store.getOrCreate(Tuple.of(FootnotesHook.class, "footnotes"), Lifespan.TRY, () -> new FootnotesCollector());
    }

    @Override
    public void registerHooks(RegistrarHook.Registrar registrar) {
        registrar.register(FootnotesResolveParameter.class, PropagationMode.ALL_DESCENDANTS);
        registrar.register(FootnotesInnermost.class, PropagationMode.ALL_DESCENDANTS);
        registrar.register(FootnotesOutermost.class, PropagationMode.ALL_DESCENDANTS);
    }

    static class FootnotesResolveParameter
    implements ResolveParameterHook {
        FootnotesResolveParameter() {
        }

        @Override
        public Optional<ResolveParameterHook.ParameterSupplier> resolve(ParameterResolutionContext parameterContext, LifecycleContext lifecycleContext) {
            if (parameterContext.typeUsage().isOfType(Footnotes.class)) {
                ResolveParameterHook.ParameterSupplier footnotesSupplier = optionalTry -> {
                    Tuple.Tuple2 labelAndStore = optionalTry.map(tryLifecycleContext -> Tuple.of(tryLifecycleContext.label(), FootnotesHook.getFootnotesCollectorStore())).orElseThrow(() -> {
                        String message = String.format("Illegal argument [%s] in method [%s].%nObjects of type %s can only be injected directly in property methods or in @BeforeTry and @AfterTry lifecycle methods.", parameterContext.parameter(), parameterContext.optionalMethod().map(Method::toString).orElse("unknown"), Footnotes.class);
                        return new IllegalArgumentException(message);
                    });
                    return new StoreBasedFootnotes(labelAndStore);
                };
                return Optional.of(footnotesSupplier);
            }
            return Optional.empty();
        }
    }

    static class FootnotesInnermost
    implements AroundTryHook {
        FootnotesInnermost() {
        }

        @Override
        public TryExecutionResult aroundTry(TryLifecycleContext context, TryExecutor aTry, List<Object> parameters) {
            TryExecutionResult executionResult = aTry.execute(parameters);
            if (executionResult.isFalsified()) {
                ((FootnotesCollector)FootnotesHook.getFootnotesCollectorStore().get()).evaluateInnermost();
            }
            return executionResult;
        }

        @Override
        public int aroundTryProximity() {
            return 99;
        }
    }

    static class FootnotesOutermost
    implements AroundTryHook {
        FootnotesOutermost() {
        }

        @Override
        public TryExecutionResult aroundTry(TryLifecycleContext context, TryExecutor aTry, List<Object> parameters) {
            TryExecutionResult executionResult = aTry.execute(parameters);
            if (executionResult.isFalsified()) {
                ((FootnotesCollector)FootnotesHook.getFootnotesCollectorStore().get()).evaluateOutermost();
                return executionResult.withFootnotes(this.getFootnotes());
            }
            return executionResult;
        }

        private List<String> getFootnotes() {
            return ((FootnotesCollector)FootnotesHook.getFootnotesCollectorStore().get()).getFootnotes();
        }

        @Override
        public int aroundTryProximity() {
            return -20;
        }
    }

    private static class FootnotesCollector {
        private final List<String> footnotes = new ArrayList<String>();
        private final List<String> collectedFootnotes = new ArrayList<String>();
        private final List<Supplier<String>> collectedSuppliers = new ArrayList<Supplier<String>>();

        private FootnotesCollector() {
        }

        private List<String> getFootnotes() {
            return this.footnotes;
        }

        private void addFootnote(String footnote) {
            this.collectedFootnotes.add(footnote);
        }

        private void addAfterFailure(Supplier<String> footnoteSupplier) {
            this.collectedSuppliers.add(footnoteSupplier);
        }

        private void evaluateInnermost() {
            for (Supplier<String> footnoteSupplier : this.collectedSuppliers) {
                this.footnotes.add(footnoteSupplier.get());
            }
        }

        private void evaluateOutermost() {
            for (String footnote : this.collectedFootnotes) {
                this.footnotes.add(footnote);
            }
        }
    }

    private static class StoreBasedFootnotes
    implements Footnotes {
        private final String label;
        private final Store<FootnotesCollector> store;

        private StoreBasedFootnotes(Tuple.Tuple2<String, Store<FootnotesCollector>> labelAndStore) {
            this.label = (String)labelAndStore.get1();
            this.store = labelAndStore.get2();
        }

        @Override
        public void addFootnote(String footnote) {
            this.store.get().addFootnote(footnote);
        }

        @Override
        public void addAfterFailure(Supplier<String> footnoteSupplier) {
            this.store.get().addAfterFailure(footnoteSupplier);
        }

        public String toString() {
            return String.format("%s[%s]", Footnotes.class.getName(), this.label);
        }
    }
}

