/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.ShrinkingDistanceArraysSupport;
import org.apiguardian.api.API;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@API(status=API.Status.STABLE, since="1.0")
public class ShrinkingDistance
implements Comparable<ShrinkingDistance> {
    @API(status=API.Status.MAINTAINED, since="1.2.0")
    public static final ShrinkingDistance MAX = ShrinkingDistance.of(Long.MAX_VALUE);
    @API(status=API.Status.MAINTAINED, since="1.7.2")
    public static final ShrinkingDistance MIN = ShrinkingDistance.of(0L);
    private final long[] distances;

    @API(status=API.Status.MAINTAINED, since="1.0")
    public static ShrinkingDistance of(long ... distances) {
        if (distances.length == 0) {
            throw new IllegalArgumentException("ShrinkingDistance requires at least one value");
        }
        if (Arrays.stream(distances).anyMatch(d -> d < 0L)) {
            throw new IllegalArgumentException("ShrinkingDistance does not allow negative values");
        }
        return new ShrinkingDistance(distances);
    }

    @API(status=API.Status.MAINTAINED, since="1.0")
    public static <T> ShrinkingDistance forCollection(Collection<Shrinkable<T>> elements) {
        long[] collectedDistances = ShrinkingDistanceArraysSupport.sumUp(ShrinkingDistance.toDistances(elements));
        ShrinkingDistance sumDistanceOfElements = new ShrinkingDistance(collectedDistances);
        return ShrinkingDistance.of(elements.size()).append(sumDistanceOfElements);
    }

    @API(status=API.Status.MAINTAINED, since="1.0")
    public static <T> ShrinkingDistance combine(List<Shrinkable<T>> shrinkables) {
        if (shrinkables.isEmpty()) {
            return MIN;
        }
        long[] combinedDistances = ShrinkingDistanceArraysSupport.concatenate(ShrinkingDistance.toDistances(shrinkables));
        return new ShrinkingDistance(combinedDistances);
    }

    private ShrinkingDistance(long[] distances) {
        this.distances = distances;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShrinkingDistance that = (ShrinkingDistance)o;
        return Arrays.equals(this.distances, that.distances);
    }

    public int hashCode() {
        return Arrays.hashCode(this.distances);
    }

    public String toString() {
        return String.format("ShrinkingDistance:%s", Arrays.toString(this.distances));
    }

    @Override
    public int compareTo(ShrinkingDistance other) {
        if (this == MAX) {
            if (other == MAX) {
                return 0;
            }
            return 1;
        }
        if (other == MAX) {
            return -1;
        }
        int dimensionsToCompare = Math.max(this.size(), other.size());
        for (int i = 0; i < dimensionsToCompare; ++i) {
            int compareDimensionResult = this.compareDimension(other, i);
            if (compareDimensionResult == 0) continue;
            return compareDimensionResult;
        }
        return 0;
    }

    @API(status=API.Status.INTERNAL)
    public List<ShrinkingDistance> dimensions() {
        return Arrays.stream(this.distances).mapToObj(xva$0 -> ShrinkingDistance.of(xva$0)).collect(Collectors.toList());
    }

    @API(status=API.Status.INTERNAL)
    public int size() {
        return this.distances.length;
    }

    private int compareDimension(ShrinkingDistance other, int i) {
        long left = ShrinkingDistanceArraysSupport.at(this.distances, i);
        long right = ShrinkingDistanceArraysSupport.at(other.distances, i);
        return Long.compare(left, right);
    }

    @API(status=API.Status.INTERNAL)
    public ShrinkingDistance plus(ShrinkingDistance other) {
        long[] summedUpDistances = ShrinkingDistanceArraysSupport.sumUp(Arrays.asList(this.distances, other.distances));
        return new ShrinkingDistance(summedUpDistances);
    }

    @API(status=API.Status.INTERNAL)
    public ShrinkingDistance append(ShrinkingDistance other) {
        long[] appendedDistances = ShrinkingDistanceArraysSupport.concatenate(Arrays.asList(this.distances, other.distances));
        return new ShrinkingDistance(appendedDistances);
    }

    private static <T> @NonNull List<long[]> toDistances(Collection<Shrinkable<T>> shrinkables) {
        ArrayList<long[]> listOfDistances = new ArrayList<long[]>(shrinkables.size());
        for (Shrinkable<T> tShrinkable : shrinkables) {
            long[] longs = tShrinkable.distance().distances;
            listOfDistances.add(longs);
        }
        return listOfDistances;
    }
}

