/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.sql;

import java.math.BigDecimal;
import java.time.Duration;
import java.util.Map;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.provider.sql.SqlConfiguration;
import net.javacrumbs.shedlock.provider.sql.SqlStatementsSource;

class PostgresSqlServerTimeStatementsSource
extends SqlStatementsSource {
    private static final String now = "timezone('utc', CURRENT_TIMESTAMP)";
    private static final String lockAtMostFor = "timezone('utc', CURRENT_TIMESTAMP) + make_interval(secs => :lockAtMostForInterval)";

    PostgresSqlServerTimeStatementsSource(SqlConfiguration configuration) {
        super(configuration);
    }

    @Override
    public String getInsertStatement() {
        return "INSERT INTO " + this.tableName() + "(" + this.name() + ", " + this.lockUntil() + ", " + this.lockedAt() + ", " + this.lockedBy() + ") VALUES(:name, timezone('utc', CURRENT_TIMESTAMP) + make_interval(secs => :lockAtMostForInterval), timezone('utc', CURRENT_TIMESTAMP), :lockedBy) ON CONFLICT (" + this.name() + ") DO UPDATE" + this.updateClause();
    }

    private String updateClause() {
        return " SET " + this.lockUntil() + " = timezone('utc', CURRENT_TIMESTAMP) + make_interval(secs => :lockAtMostForInterval), " + this.lockedAt() + " = timezone('utc', CURRENT_TIMESTAMP), " + this.lockedBy() + " = :lockedBy WHERE " + this.tableName() + "." + this.name() + " = :name AND " + this.tableName() + "." + this.lockUntil() + " <= timezone('utc', CURRENT_TIMESTAMP)";
    }

    @Override
    public String getUpdateStatement() {
        return "UPDATE " + this.tableName() + this.updateClause();
    }

    @Override
    public String getUnlockStatement() {
        String lockAtLeastFor = this.lockedAt() + " + make_interval(secs => :lockAtLeastForInterval)";
        return "UPDATE " + this.tableName() + " SET " + this.lockUntil() + " = CASE WHEN " + lockAtLeastFor + " > timezone('utc', CURRENT_TIMESTAMP) THEN " + lockAtLeastFor + " ELSE timezone('utc', CURRENT_TIMESTAMP) END WHERE " + this.name() + " = :name AND " + this.lockedBy() + " = :lockedBy";
    }

    @Override
    public String getExtendStatement() {
        return "UPDATE " + this.tableName() + " SET " + this.lockUntil() + " = timezone('utc', CURRENT_TIMESTAMP) + make_interval(secs => :lockAtMostForInterval) WHERE " + this.name() + " = :name AND " + this.lockedBy() + " = :lockedBy AND " + this.lockUntil() + " > timezone('utc', CURRENT_TIMESTAMP)";
    }

    @Override
    public Map<String, Object> params(LockConfiguration lockConfiguration) {
        return Map.of("name", lockConfiguration.getName(), "lockedBy", this.configuration.getLockedByValue(), "lockAtMostForInterval", PostgresSqlServerTimeStatementsSource.toSeconds(lockConfiguration.getLockAtMostFor()), "lockAtLeastForInterval", PostgresSqlServerTimeStatementsSource.toSeconds(lockConfiguration.getLockAtLeastFor()));
    }

    private static BigDecimal toSeconds(Duration duration) {
        return BigDecimal.valueOf(duration.toMillis()).scaleByPowerOfTen(-3);
    }
}

