/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.sql;

import java.util.Map;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.provider.sql.SqlConfiguration;
import net.javacrumbs.shedlock.provider.sql.SqlStatementsSource;

class Db2ServerTimeStatementsSource
extends SqlStatementsSource {
    private static final String now = "(CURRENT TIMESTAMP - CURRENT TIMEZONE)";
    private static final String lockAtMostFor = "((CURRENT TIMESTAMP - CURRENT TIMEZONE) + :lockAtMostForMicros MICROSECONDS)";

    Db2ServerTimeStatementsSource(SqlConfiguration configuration) {
        super(configuration);
    }

    @Override
    public String getInsertStatement() {
        return "INSERT INTO " + this.tableName() + "(" + this.name() + ", " + this.lockUntil() + ", " + this.lockedAt() + ", " + this.lockedBy() + ") VALUES(:name, ((CURRENT TIMESTAMP - CURRENT TIMEZONE) + :lockAtMostForMicros MICROSECONDS), (CURRENT TIMESTAMP - CURRENT TIMEZONE), :lockedBy)";
    }

    @Override
    public String getUpdateStatement() {
        return "UPDATE " + this.tableName() + " SET " + this.lockUntil() + " = ((CURRENT TIMESTAMP - CURRENT TIMEZONE) + :lockAtMostForMicros MICROSECONDS), " + this.lockedAt() + " = (CURRENT TIMESTAMP - CURRENT TIMEZONE), " + this.lockedBy() + " = :lockedBy WHERE " + this.name() + " = :name AND " + this.lockUntil() + " <= (CURRENT TIMESTAMP - CURRENT TIMEZONE)";
    }

    @Override
    public String getUnlockStatement() {
        String lockAtLeastFor = "(" + this.lockedAt() + "+ :lockAtLeastForMicros MICROSECONDS)";
        return "UPDATE " + this.tableName() + " SET " + this.lockUntil() + " = CASE WHEN " + lockAtLeastFor + " > (CURRENT TIMESTAMP - CURRENT TIMEZONE) THEN " + lockAtLeastFor + " ELSE (CURRENT TIMESTAMP - CURRENT TIMEZONE) END WHERE " + this.name() + " = :name AND " + this.lockedBy() + " = :lockedBy";
    }

    @Override
    public String getExtendStatement() {
        return "UPDATE " + this.tableName() + " SET " + this.lockUntil() + " = ((CURRENT TIMESTAMP - CURRENT TIMEZONE) + :lockAtMostForMicros MICROSECONDS) WHERE " + this.name() + " = :name AND " + this.lockedBy() + " = :lockedBy AND " + this.lockUntil() + " > (CURRENT TIMESTAMP - CURRENT TIMEZONE)";
    }

    @Override
    public Map<String, Object> params(LockConfiguration lockConfiguration) {
        return Map.of("name", lockConfiguration.getName(), "lockedBy", this.configuration.getLockedByValue(), "lockAtMostForMicros", lockConfiguration.getLockAtMostFor().toNanos() / 1000L, "lockAtLeastForMicros", lockConfiguration.getLockAtLeastFor().toNanos() / 1000L);
    }
}

