/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.spring;

import java.util.function.Consumer;
import java.util.function.Function;
import net.javacrumbs.jsonunit.core.Configuration;
import net.javacrumbs.jsonunit.core.internal.matchers.InternalMatcher;
import net.javacrumbs.jsonunit.spring.AbstractSpringMatcher;
import net.javacrumbs.jsonunit.spring.AbstractSpringMatchers;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.mock.http.client.MockClientHttpRequest;
import org.springframework.test.web.client.RequestMatcher;

public class JsonUnitRequestMatchers
extends AbstractSpringMatchers<JsonUnitRequestMatchers, RequestMatcher> {
    private JsonUnitRequestMatchers(Configuration configuration, Function<Object, Object> jsonTransformer) {
        super(configuration, jsonTransformer);
    }

    @Override
    RequestMatcher matcher(Consumer<InternalMatcher> matcher) {
        return new JsonRequestMatcher(this.configuration, matcher, this.jsonTransformer);
    }

    @Override
    JsonUnitRequestMatchers matchers(Configuration configuration, Function<Object, Object> jsonTransformer) {
        return new JsonUnitRequestMatchers(configuration, jsonTransformer);
    }

    public static JsonUnitRequestMatchers json() {
        return new JsonUnitRequestMatchers(Configuration.empty(), Function.identity());
    }

    private static class JsonRequestMatcher
    extends AbstractSpringMatcher
    implements RequestMatcher {
        private JsonRequestMatcher(Configuration configuration, Consumer<InternalMatcher> matcher, Function<Object, Object> jsonTransformer) {
            super(configuration, matcher, jsonTransformer);
        }

        public void match(ClientHttpRequest request) throws AssertionError {
            String actual = ((MockClientHttpRequest)request).getBodyAsString();
            this.doMatch(actual);
        }
    }
}

