/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.spring;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.function.BiConsumer;
import net.javacrumbs.jsonunit.core.Configuration;
import net.javacrumbs.jsonunit.core.internal.Path;
import net.javacrumbs.jsonunit.core.internal.matchers.InternalMatcher;
import net.javacrumbs.jsonunit.spring.AbstractSpringMatcher;
import net.javacrumbs.jsonunit.spring.AbstractSpringMatchers;
import org.jetbrains.annotations.NotNull;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.ResultMatcher;

public class JsonUnitResultMatchers
extends AbstractSpringMatchers<JsonUnitResultMatchers, ResultMatcher> {
    private JsonUnitResultMatchers(Path path, Configuration configuration) {
        super(path, configuration);
    }

    public static JsonUnitResultMatchers json() {
        return new JsonUnitResultMatchers(Path.root(), Configuration.empty());
    }

    @Override
    @NotNull
    ResultMatcher matcher(@NotNull BiConsumer<Object, InternalMatcher> matcher) {
        return new JsonResultMatcher(this.path, this.configuration, matcher);
    }

    @Override
    @NotNull
    JsonUnitResultMatchers matchers(@NotNull Path path, @NotNull Configuration configuration) {
        return new JsonUnitResultMatchers(path, configuration);
    }

    private static class JsonResultMatcher
    extends AbstractSpringMatcher
    implements ResultMatcher {
        private JsonResultMatcher(@NotNull Path path, @NotNull Configuration configuration, @NotNull BiConsumer<Object, InternalMatcher> matcher) {
            super(path, configuration, matcher);
        }

        public void match(@NotNull MvcResult result) throws Exception {
            String actual = this.getContentAsString(result.getResponse());
            this.doMatch(actual);
        }

        @NotNull
        private String getContentAsString(@NotNull MockHttpServletResponse response) throws UnsupportedEncodingException {
            return response.getContentAsString(StandardCharsets.UTF_8);
        }
    }
}

