/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.spring;

import java.math.BigDecimal;
import net.javacrumbs.jsonunit.core.Configuration;
import net.javacrumbs.jsonunit.core.Option;
import net.javacrumbs.jsonunit.core.internal.Diff;
import net.javacrumbs.jsonunit.core.internal.JsonUtils;
import net.javacrumbs.jsonunit.core.internal.Node;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.ResultMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonUnitResultMatchers {
    private final String path;
    private final Configuration configuration;

    private JsonUnitResultMatchers(String path, Configuration configuration) {
        this.path = path;
        this.configuration = configuration;
    }

    public static JsonUnitResultMatchers json() {
        return new JsonUnitResultMatchers("", Configuration.empty());
    }

    public JsonUnitResultMatchers node(String path) {
        return new JsonUnitResultMatchers(path, this.configuration);
    }

    public ResultMatcher isEqualTo(final Object expected) {
        return new AbstractResultMatcher(this.path, this.configuration){

            public void doMatch(Object actual) {
                Diff diff = this.createDiff(expected, actual);
                if (!diff.similar()) {
                    JsonUnitResultMatchers.failWithMessage(diff.differences());
                }
            }
        };
    }

    public ResultMatcher isStringEqualTo(final String expected) {
        return new AbstractResultMatcher(this.path, this.configuration){

            public void doMatch(Object actual) {
                this.isString(actual);
                Node node = this.getNode(actual);
                if (!node.asText().equals(expected)) {
                    JsonUnitResultMatchers.failWithMessage("Node \"" + JsonUnitResultMatchers.this.path + "\" is not equal to \"" + expected + "\".");
                }
            }
        };
    }

    public ResultMatcher isNotEqualTo(final String expected) {
        return new AbstractResultMatcher(this.path, this.configuration){

            public void doMatch(Object actual) {
                Diff diff = this.createDiff(expected, actual);
                if (diff.similar()) {
                    JsonUnitResultMatchers.failWithMessage("JSON is equal.");
                }
            }
        };
    }

    public ResultMatcher isAbsent() {
        return new AbstractResultMatcher(this.path, this.configuration){

            public void doMatch(Object actual) {
                if (JsonUtils.nodeExists((Object)actual, (String)JsonUnitResultMatchers.this.path)) {
                    JsonUnitResultMatchers.failWithMessage("Node \"" + JsonUnitResultMatchers.this.path + "\" is present.");
                }
            }
        };
    }

    public ResultMatcher isPresent() {
        return new AbstractResultMatcher(this.path, this.configuration){

            public void doMatch(Object actual) {
                this.isPresent(actual);
            }
        };
    }

    public ResultMatcher isArray() {
        return new AbstractResultMatcher(this.path, this.configuration){

            public void doMatch(Object actual) {
                this.isPresent(actual);
                Node node = this.getNode(actual);
                if (node.getNodeType() != Node.NodeType.ARRAY) {
                    this.failOnType(node, "an array");
                }
            }
        };
    }

    public ResultMatcher isObject() {
        return new AbstractResultMatcher(this.path, this.configuration){

            public void doMatch(Object actual) {
                this.isPresent(actual);
                Node node = this.getNode(actual);
                if (node.getNodeType() != Node.NodeType.OBJECT) {
                    this.failOnType(node, "an object");
                }
            }
        };
    }

    public ResultMatcher isString() {
        return new AbstractResultMatcher(this.path, this.configuration){

            public void doMatch(Object actual) {
                this.isString(actual);
            }
        };
    }

    public JsonUnitResultMatchers ignoring(String ignorePlaceholder) {
        return new JsonUnitResultMatchers(this.path, this.configuration.withIgnorePlaceholder(ignorePlaceholder));
    }

    public JsonUnitResultMatchers withTolerance(double tolerance) {
        return this.withTolerance(BigDecimal.valueOf(tolerance));
    }

    public JsonUnitResultMatchers withTolerance(BigDecimal tolerance) {
        return new JsonUnitResultMatchers(this.path, this.configuration.withTolerance(tolerance));
    }

    public JsonUnitResultMatchers when(Option firstOption, Option ... otherOptions) {
        return new JsonUnitResultMatchers(this.path, this.configuration.withOptions(firstOption, otherOptions));
    }

    public ResultMatcher matches(final Matcher<?> matcher) {
        return new AbstractResultMatcher(this.path, this.configuration){

            public void doMatch(Object actual) {
                this.isPresent(actual);
                Node node = this.getNode(actual);
                MatcherAssert.assertThat((String)("Node \"" + JsonUnitResultMatchers.this.path + "\" does not match."), (Object)node.getValue(), (Matcher)matcher);
            }
        };
    }

    private static void failWithMessage(String message) {
        throw new AssertionError((Object)message);
    }

    private static abstract class AbstractResultMatcher
    implements ResultMatcher {
        private final String path;
        private final Configuration configuration;

        protected AbstractResultMatcher(String path, Configuration configuration) {
            this.path = path;
            this.configuration = configuration;
        }

        public void match(MvcResult result) throws Exception {
            String actual = result.getResponse().getContentAsString();
            this.doMatch(actual);
        }

        protected Diff createDiff(Object expected, Object actual) {
            return Diff.create((Object)expected, (Object)actual, (String)"actual", (String)this.path, (Configuration)this.configuration);
        }

        protected void isPresent(Object actual) {
            if (!JsonUtils.nodeExists((Object)actual, (String)this.path)) {
                JsonUnitResultMatchers.failWithMessage("Node \"" + this.path + "\" is missing.");
            }
        }

        protected void failOnType(Node node, String type) {
            JsonUnitResultMatchers.failWithMessage("Node \"" + this.path + "\" is not " + type + ". The actual value is '" + node + "'.");
        }

        protected Node getNode(Object actual) {
            return JsonUtils.getNode((Object)actual, (String)this.path);
        }

        protected void isString(Object actual) {
            this.isPresent(actual);
            Node node = this.getNode(actual);
            if (node.getNodeType() != Node.NodeType.STRING) {
                this.failOnType(node, "a string");
            }
        }

        protected abstract void doMatch(Object var1);
    }
}

