/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.assertj;

import net.javacrumbs.jsonunit.assertj.ExpectedNode;
import net.javacrumbs.jsonunit.assertj.JsonAssert;
import net.javacrumbs.jsonunit.assertj.internal.JsonRepresentation;
import net.javacrumbs.jsonunit.core.Configuration;
import net.javacrumbs.jsonunit.core.internal.JsonUtils;
import org.assertj.core.api.AssertFactory;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactory;
import org.assertj.core.presentation.Representation;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class JsonAssertions {
    public static final InstanceOfAssertFactory<Object, JsonAssert.ConfigurableJsonAssert> JSON = new InstanceOfAssertFactory(Object.class, JsonAssertions.jsonUnitJson());

    private JsonAssertions() {
    }

    public static @NonNull JsonAssert.ConfigurableJsonAssert assertThatJson(@Nullable Object actual) {
        return new JsonAssert.ConfigurableJsonAssert(actual, Configuration.empty());
    }

    public static @NonNull JsonAssert.ConfigurableJsonAssert assertThatJson(@NonNull Object actual, JsonAssertionCallback ... callbacks) {
        JsonAssert.ConfigurableJsonAssert a = JsonAssertions.assertThatJson(actual);
        for (JsonAssertionCallback callback : callbacks) {
            callback.doAssert(a);
        }
        return a;
    }

    public static @NonNull Object json(Object input) {
        return new ExpectedNode(JsonUtils.convertToJson((Object)input, (String)"expected", (boolean)true));
    }

    public static @NonNull Object value(Object input) {
        return new ExpectedNode(JsonUtils.wrapDeserializedObject((Object)input));
    }

    public static AssertFactory<Object, JsonAssert.ConfigurableJsonAssert> jsonUnitJson() {
        return new JsonUnitAssertFactory();
    }

    static {
        Assertions.useRepresentation((Representation)new JsonRepresentation());
    }

    @FunctionalInterface
    public static interface JsonAssertionCallback {
        public void doAssert(@NonNull JsonAssert.ConfigurableJsonAssert var1);
    }

    private static class JsonUnitAssertFactory
    implements AssertFactory<Object, JsonAssert.ConfigurableJsonAssert> {
        private JsonUnitAssertFactory() {
        }

        public JsonAssert.ConfigurableJsonAssert createAssert(Object actual) {
            return new JsonAssert.ConfigurableJsonAssert(actual, Configuration.empty());
        }
    }
}

