/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.assertj;

import net.javacrumbs.jsonunit.assertj.JsonComparator;
import net.javacrumbs.jsonunit.core.Configuration;
import net.javacrumbs.jsonunit.core.internal.Diff;
import net.javacrumbs.jsonunit.core.internal.Path;
import org.assertj.core.api.AbstractObjectAssert;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectAssert
extends AbstractObjectAssert<JsonObjectAssert, Object> {
    private final Configuration configuration;
    private final Path path;

    JsonObjectAssert(Object actual, Path path, Configuration configuration) {
        super(actual, JsonObjectAssert.class);
        this.path = path;
        this.configuration = configuration;
        this.usingComparator(new JsonComparator(configuration, path.asPrefix(), true));
    }

    @NotNull
    public JsonObjectAssert isEqualTo(@Nullable Object expected) {
        return this.compare(expected, this.configuration);
    }

    @Deprecated
    @NotNull
    public JsonObjectAssert isEqualToIgnoringGivenFields(@Nullable Object other, String ... propertiesOrFieldsToIgnore) {
        return this.compare(other, this.configuration.whenIgnoringPaths(propertiesOrFieldsToIgnore));
    }

    @Deprecated
    @NotNull
    public JsonObjectAssert isEqualToComparingOnlyGivenFields(@Nullable Object other, String ... propertiesOrFieldsUsedInComparison) {
        throw this.unsupportedOperation();
    }

    @Deprecated
    @NotNull
    public JsonObjectAssert isEqualToIgnoringNullFields(@Nullable Object other) {
        throw this.unsupportedOperation();
    }

    @Deprecated
    @NotNull
    public JsonObjectAssert isEqualToComparingFieldByField(@Nullable Object other) {
        throw this.unsupportedOperation();
    }

    @Deprecated
    @NotNull
    public JsonObjectAssert isEqualToComparingFieldByFieldRecursively(@Nullable Object other) {
        throw this.unsupportedOperation();
    }

    @Deprecated
    public JsonObjectAssert hasFieldOrProperty(String name) {
        return (JsonObjectAssert)super.hasFieldOrProperty(name);
    }

    @Deprecated
    public JsonObjectAssert hasFieldOrPropertyWithValue(String name, Object value) {
        return (JsonObjectAssert)super.hasFieldOrPropertyWithValue(name, value);
    }

    @Deprecated
    public JsonObjectAssert hasAllNullFieldsOrProperties() {
        return (JsonObjectAssert)super.hasAllNullFieldsOrProperties();
    }

    @Deprecated
    public JsonObjectAssert hasAllNullFieldsOrPropertiesExcept(String ... propertiesOrFieldsToIgnore) {
        return (JsonObjectAssert)super.hasAllNullFieldsOrPropertiesExcept(propertiesOrFieldsToIgnore);
    }

    @Deprecated
    public JsonObjectAssert hasNoNullFieldsOrProperties() {
        return (JsonObjectAssert)super.hasNoNullFieldsOrProperties();
    }

    @Deprecated
    public JsonObjectAssert hasNoNullFieldsOrPropertiesExcept(String ... propertiesOrFieldsToIgnore) {
        return (JsonObjectAssert)super.hasNoNullFieldsOrPropertiesExcept(propertiesOrFieldsToIgnore);
    }

    @NotNull
    private UnsupportedOperationException unsupportedOperation() {
        return new UnsupportedOperationException("Operation not supported for JSON documents");
    }

    @NotNull
    private JsonObjectAssert compare(@Nullable Object other, @NotNull Configuration configuration) {
        this.describedAs(null);
        Diff diff = Diff.create((Object)other, (Object)this.actual, (String)"fullJson", (Path)this.path, (Configuration)configuration);
        diff.failIfDifferent();
        return this;
    }
}

