/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.assertj;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.javacrumbs.jsonunit.assertj.JsonComparator;
import net.javacrumbs.jsonunit.assertj.JsonListAssert;
import net.javacrumbs.jsonunit.assertj.JsonMapAssert;
import net.javacrumbs.jsonunit.core.Configuration;
import net.javacrumbs.jsonunit.core.Option;
import net.javacrumbs.jsonunit.core.internal.Diff;
import net.javacrumbs.jsonunit.core.internal.JsonUtils;
import net.javacrumbs.jsonunit.core.internal.Node;
import net.javacrumbs.jsonunit.core.internal.Path;
import net.javacrumbs.jsonunit.jsonpath.JsonPathAdapter;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.BigDecimalAssert;
import org.assertj.core.api.BooleanAssert;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.StringAssert;

public class JsonAssert
extends AbstractAssert<JsonAssert, Object> {
    final Path path;
    final Configuration configuration;

    JsonAssert(Path path, Configuration configuration, Object o) {
        super(o, JsonAssert.class);
        this.path = path;
        this.configuration = configuration;
        this.usingComparator(new JsonComparator(configuration, path, false));
    }

    JsonAssert(Object actual, Configuration configuration) {
        this(Path.create((String)"", (String)JsonUtils.getPathPrefix((Object)actual)), configuration, actual);
    }

    public JsonAssert node(String node) {
        return new JsonAssert(this.path.to(node), this.configuration, JsonUtils.getNode((Object)this.actual, (String)node));
    }

    public JsonAssert isEqualTo(Object expected) {
        Diff diff = Diff.create((Object)expected, (Object)this.actual, (String)"fullJson", (Path)this.path.asPrefix(), (Configuration)this.configuration);
        if (!diff.similar()) {
            this.failWithMessage(diff.toString(), new Object[0]);
        }
        return this;
    }

    public MapAssert<String, Object> isObject() {
        Node node = this.assertType(Node.NodeType.OBJECT);
        return (MapAssert)new JsonMapAssert((Map)node.getValue(), this.path.asPrefix(), this.configuration).as("Different value found in node \"%s\"", new Object[]{this.path});
    }

    public BigDecimalAssert isNumber() {
        Node node = this.assertType(Node.NodeType.NUMBER);
        return (BigDecimalAssert)new BigDecimalAssert(node.decimalValue()).as("Different value found in node \"%s\"", new Object[]{this.path});
    }

    public ListAssert<Object> isArray() {
        Node node = this.assertType(Node.NodeType.ARRAY);
        return (ListAssert)new JsonListAssert((List)node.getValue(), this.path.asPrefix(), this.configuration).as("Different value found in node \"%s\"", new Object[]{this.path});
    }

    public BooleanAssert isBoolean() {
        Node node = this.assertType(Node.NodeType.BOOLEAN);
        return (BooleanAssert)new BooleanAssert((Boolean)node.getValue()).as("Different value found in node \"%s\"", new Object[]{this.path});
    }

    public StringAssert isString() {
        Node node = this.assertType(Node.NodeType.STRING);
        return (StringAssert)new StringAssert((String)node.getValue()).as("Different value found in node \"%s\"", new Object[]{this.path});
    }

    public void isNull() {
        this.assertType(Node.NodeType.NULL);
    }

    public JsonAssert isPresent() {
        this.isPresent("node to be present");
        return this;
    }

    public void isAbsent() {
        if (!JsonUtils.nodeAbsent((Object)this.actual, (Path)this.path.asPrefix(), (Configuration)this.configuration)) {
            this.failOnDifference("node to be absent", Diff.quoteTextValue((Object)this.actual));
        }
    }

    public JsonAssert isNotNull() {
        this.isPresent("not null");
        Node node = JsonUtils.getNode((Object)this.actual, (String)"");
        if (node.getNodeType() == Node.NodeType.NULL) {
            this.failOnType(node, "not null");
        }
        return this;
    }

    private Node assertType(Node.NodeType type) {
        this.isPresent(type.getDescription());
        Node node = JsonUtils.getNode((Object)this.actual, (String)"");
        if (node.getNodeType() != type) {
            this.failOnType(node, type.getDescription());
        }
        return node;
    }

    private void isPresent(String expectedValue) {
        if (JsonUtils.nodeAbsent((Object)this.actual, (String)"", (Configuration)this.configuration)) {
            this.failOnDifference(expectedValue, "missing");
        }
    }

    private void failOnDifference(Object expected, Object actual) {
        this.failWithMessage(String.format("Different value found in node \"%s\", expected: <%s> but was: <%s>.", this.path, expected, actual), new Object[0]);
    }

    private void failOnType(Node node, String expectedTypeDescription) {
        this.failWithMessage("Node \"" + this.path + "\" has invalid type, expected: <" + expectedTypeDescription + "> but was: <" + Diff.quoteTextValue((Object)node.getValue()) + ">.", new Object[0]);
    }

    public static class ConfigurableJsonAssert
    extends JsonAssert {
        ConfigurableJsonAssert(Path path, Configuration configuration, Object o) {
            super(path, configuration, o);
        }

        ConfigurableJsonAssert(Object actual, Configuration configuration) {
            super(Path.create((String)"", (String)JsonUtils.getPathPrefix((Object)actual)), configuration, actual);
        }

        public ConfigurableJsonAssert when(Option first, Option ... other) {
            return this.withConfiguration(c -> c.when(first, other));
        }

        public ConfigurableJsonAssert withConfiguration(Function<Configuration, Configuration> configurationFunction) {
            return new ConfigurableJsonAssert(this.path, configurationFunction.apply(this.configuration), this.actual);
        }

        public JsonAssert inPath(String jsonPath) {
            return new JsonAssert(JsonPathAdapter.inPath((Object)this.actual, (String)jsonPath), this.configuration);
        }
    }
}

